#!/bin/sh

# number of seconds the button should be pressed to reset to defaults
COUNT=3

num=1
while [ $num -eq 1 ]; do

sleep 1

if [ -e /tmp/rebootFlag ]
then
	/app/scripts/reboot &
fi

if [ -e /tmp/firmwareUpdate ]
then
	sleep 5
	mv /tmp/apps_BASremote_ver*.tgz /tmp/apps.tgz
	/app/scripts/setup-notftp.sh
	sleep 1	
	/app/scripts/reboot
fi

# Get portf status.
portf_val=$(portf | cut -d' ' -f4)

# Check default pushbutton
portf_val=$(($portf_val & 0x02))

# If default pushbutton is low for desired time.
if [ "$portf_val" = "0" ]
then
	i=$(($i+1))
else	
	i=0	
fi

if [ "$i" = "$COUNT" ]
then
	echo "Default pushbutton pressed: setting default ip and passwords."
	#
	cd /data/config
	tar -xzf /scripts/recover-network.tgz
	cd -
	# _RCW_:11-Mar-2014: Now using a recover-etc.tgz from /app/scripts.
	# This has the passwords, issue(s), and lighttpd files.
	/scripts/read-write.sh
	cd /etc
	tar -xzf /app/scripts/recover-etc.tgz
	cd -
	sleep 3
	/scripts/read-only.sh
	# Store new config so it's good for next boot.
	# Does nothing for JFFS2 file systems.
	/scripts/config_store
	# Raise CCI_BIT so that led will blink.
	portf 0xff
	# Wait a bit.
	sleep 3
	# Lower CCI_BIT so that led will be solid again.
	portf 0xfb
fi

done
