/**
 * Created with JetBrains WebStorm.
 * User: rcw
 * Date: 6/2/13
 * Time: 12:53 PM
 * To change this template use File | Settings | File Templates.
 */

/**
 * Document for getting trend configuration data.
 *
 * <rdom rsp="ack">
 *		<trend>															0
 *			<sample_interval>10</sample_interval>						1
 *			<save_interval>60</save_interval>							2
 *			<ntp_enabled>1</ntp_enabled>								3
 *			<ntp_server>64.236.96.53</ntp_server>						4
 *			<ntp_interval>86400</ntp_interval>							5
 *			<objects>													6
 *				<obj sampled="1" idx="1" instance="1" name="nnn"/>		7 ,8 ,9 ,10,11
 *					o													12,13,14,15,16
 *					o
 *				<obj sampled="0" idx="n" instance="n" name="nnn"/>
 *			</objects>
 *		</trend>
 * </rdom>
 */
var trend = new rdomDoc("trend.xml", "cgi-bin/cgi-trend.cgi");

/**
 * Create the "sys.xml" virtual file used to send commands to the
 * trend server.
 *
 * <rdom rsp="ack">
 * 		<sys>							index 0
 * 			<submit>1</submit>			index 1
 * 		</sys>
 * </rdom>
 */
var sys   = new rdomDoc("sys.xml" , "cgi-bin/cgi-trend.cgi");

/**
 * rdomEle tree created from dom tree created from trend.xml.
 */
var eTrend;

/**
 * Callback timer handle.
 */
var callbackTimer;

/**
 * Form elements.
 */
/** @type {FormObject} */
var ebxSampleInterval;
/** @type {FormObject} */
var ebxSaveInterval;

/** @type {jQuery} */
var divObjectList;
/** @type {jQuery} */
var divCkbList;

/** @type {FormObject} */
var ebxProgress;
/** @type {FormObject} */
var lblProgress;

/** @type {FormObject} */
var btnSubmit;

/** @type {FormObject} */
var btnAll;
/** @type {FormObject} */
var btnNone;

/** @type {FormObject} */
var lblHelp;

/**
 * @constructor
 */
function ObjElement()
{
	/** @type {boolean} */
    this.sampled = false;
	/** @type {string} */
    this.path = '';
	/** @type {string} */
	this.instance = '';
	/** @type {string} */
    this.name = '';
	/** @type {FormObject} */
	this.checkbox = null;
}
//
/** @type {Array.<ObjElement>} */
var objList = [];
/** @type {number} */
var progressCount;

function AddCheckboxes()
{
	/** @type {number} */
    var i;
	/** @type {jQuery} */
    var newLabel;
	/** @type {jQuery} */
    var textnode;
	/** @type {jQuery} */
    var span;
	/** @type {string} */
    var szText;
	/** @type {number} */
    var boxQty;
	/** @type {ObjElement} */
    var obj;
	/** @type {jQuery} */
	var newCkb;

    boxQty = objList.length;

    for (i = 0 ; i < boxQty ; ++i)
    {
        obj = objList[i];

		szText = 'ckbId' + (i+1).toString();

		newCkb = $('<input/>' ,
			{
				id:szText,
				type:'checkbox',
				checked: obj.sampled
			});
		divObjectList.append(newCkb);
		obj.checkbox = new FormObject(fmoType.CheckItem , szText);

//        input = document.createElement("input");
//        input.id = szText;
//        input.type = 'checkbox';
//        input.checked = obj.sampled;
//        obj.checkbox = input;
//
//        divCkbList.appendChild(input);

		newLabel = $('<label/>');
		szText = ' Instance=' + obj.instance + ' : Name=' + obj.name;
		textnode = $(document.createTextNode(szText));
		span = $('<span/>');
		span.css({fontFamily:'Courier'});
		span.append(textnode);
		newLabel.append(span);
		divObjectList.append(newLabel);

//        newLabel = document.createElement('label');
//        szText = ' Instance=' + obj.instance + ' : Name=' + obj.name;
//        textnode = document.createTextNode(szText);
//        span = document.createElement('span');
//        span.style.fontFamily = 'Courier';
//        span.appendChild(textnode);
//        newLabel.appendChild(span);
//
//        divCkbList.appendChild(newLabel);

		divObjectList.append($('<br/>'));

//        divCkbList.appendChild(document.createElement("br"));
    }
}

//#############################################################################
//
//  Button handler functions.
//
//#############################################################################

function SubmitHandler(ele_id)
{
	/** @type {number} */
	var i;
	/** @type {number} */
	var maxIdx;
	/** @type {ObjElement} */
	var obj;

    // Send all the edit boxes.
    trend.SetText(ebxSampleInterval.xtag , ebxSampleInterval.GetValue() , null);
    trend.SetText(ebxSaveInterval.xtag , ebxSaveInterval.GetValue() , null);

    // Show progress.
    lblProgress.SetHidden(false);
    ebxProgress.SetHidden(false);

    // Set initial index.
    progressCount = 0;

	// For each object except the last one.
	for (i = 0 , maxIdx = objList.length - 1 ; i < maxIdx ; ++i)
	{
		obj = objList[i];
		trend.SetText(obj.path , obj.checkbox.GetValue() , function(rdoc)
		{
			ebxProgress.SetValue(progressCount.toString());
			++progressCount;
		});
	}

	// Last one tells the server to save the data, then clears the counter box.
	obj = objList[i];
	trend.SetText(obj.path , obj.checkbox.GetValue() , function(rdoc)
	{
		// Tell the trend server to create a new "trend_cfg.xml" file and restart.
		sys.SetText('submit' , '1' , function(rdoc)
		{
			// Hide progress.
			lblProgress.SetHidden(true);
			ebxProgress.SetHidden(true);
		});
	});
}

function SelectAllHandler(ele_id)
{
    var i;

    // For each list object.
    for (i = 0 ; i < objList.length ; ++i)
    {
        objList[i].checkbox.SetValue('1');
    }
}

function SelectNoneHandler(ele_id)
{
    var i;

    // For each list object.
    for (i = 0 ; i < objList.length ; ++i)
    {
        objList[i].checkbox.SetValue('0');
    }
}

//#############################################################################
//
//  "Main()"; executed after EVERYTHING on the page has loaded.
//  Recommended window size is 1000W x 700H.
//
//#############################################################################

$(document).ready(function()
{
	/** @type {number} */
    var i;
	/** @type {ObjElement} */
    var newObjEle;
	/** @type {string} */
    var szTmp;
	/** @type {rdomDoc} */
	var doc;
	/** @type {jQuery | null} */
	var trendXml;
	/** @type {jQuery | null} */
	var obj_list;
	/** @type {jQuery | null} */
	var obj;

    // Progress edit box, hidden at the start.
    lblProgress = new FormObject(fmoType.Label , 'wb_LblProgress');
    lblProgress.SetHidden(true);
    ebxProgress = new FormObject(fmoType.EditBox , 'EbxProgress');
    ebxProgress.SetHidden(true);

	// Get object list div.
	divObjectList = $('#DivObjectList');
	// Add border and scrollbar.
	divObjectList.css({'border':'2px solid #ccc','overflowY':'scroll'});

    // Initialize edit boxes.
    ebxSampleInterval = new FormObject(fmoType.EditBox , 'EbxSampleInterval');
	ebxSampleInterval.xtag = 'sample_interval';

    ebxSaveInterval = new FormObject(fmoType.EditBox , 'EbxSaveInterval');
	ebxSaveInterval.xtag = 'save_interval';

	// Initialize buttons.
	btnSubmit = new FormObject(fmoType.Button , 'BtnSubmit');
	btnSubmit.SetOnclickHandler(SubmitHandler);

	btnAll = new FormObject(fmoType.Button , 'BtnAll');
	btnAll.SetOnclickHandler(SelectAllHandler);

	btnNone = new FormObject(fmoType.Button , 'BtnNone');
	btnNone.SetOnclickHandler(SelectNoneHandler);

	// Help label.
	var tmp1 , tmp2 , tmp3 , tmp4;
	lblHelp = new FormObject(fmoType.Label , 'wb_LblHelp');
	lblHelp.SetLink('help.html#trend');
	$(lblHelp.jqObj[0]).find('a').attr('target' , '_BAShelp');

	/*
	 * Get entire trend file.
	 */
	trend.GetXmlDom('/' , true , function(rdoc)
	{
		doc = rdoc;
		trendXml = doc.response;
		obj_list = trendXml.children('objects').children();

		ebxSampleInterval.SetValue(trendXml.children(ebxSampleInterval.xtag).text());
		ebxSaveInterval.SetValue(trendXml.children(ebxSaveInterval.xtag).text());

		// For each <obj> element.
		for (i = 0 ; i < obj_list.length ; ++i)
		{
			// Get the object.
			obj = obj_list.eq(i);
			// Create new blank object.
			newObjEle = new ObjElement();
			// Add members; 'sampled' will be compared with input checkbox
			// 'checked' when the submit button is pressed.
			szTmp = obj.attr('sampled');
			newObjEle.sampled = szTmp === '1';
			newObjEle.path = 'objects/obj[' + i.toString() + ']:sampled';
			newObjEle.instance = obj.attr('instance');
			newObjEle.name = obj.attr('name');
			newObjEle.checkbox = null;
			// Add to list.
			objList.push(newObjEle);
		}

		// PopulateObjList(50);
		AddCheckboxes();
	});
});