// LocalDlg.cpp : implementation file
//

#include "stdafx.h"
#include "arcview.h"
#include "LocalDlg.h"
//
#include "Globals.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLocalDlg dialog


CLocalDlg::CLocalDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLocalDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLocalDlg)
	//}}AFX_DATA_INIT
}


void CLocalDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLocalDlg)
	DDX_Control(pDX, IDC_128NAKS, m_128Naks);
	DDX_Control(pDX, IDC_TIMEOUTS, m_Timeouts);
	DDX_Control(pDX, IDC_RXALL, m_ReceiveAll);
	DDX_Control(pDX, IDC_NODEID, m_NodeID);
	DDX_Control(pDX, IDC_DEVICE, m_Device);
	DDX_Control(pDX, IDC_DATARATE, m_DataRate);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLocalDlg, CDialog)
	//{{AFX_MSG_MAP(CLocalDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLocalDlg message handlers

void CLocalDlg::OnOK() 
{
	int		node_id , device;
	
	// Check node id.
	node_id = GetDlgItemInt( IDC_NODEID , NULL , TRUE );
	if ( ( node_id <= 0 ) || ( node_id > 255 ) )
	{
		MessageBox( "Node ID must be between 1 and 255" , "Node ID Error" , MB_OK | MB_ICONEXCLAMATION );
		return;
	}
	// Check device number.
	device = GetDlgItemInt( IDC_DEVICE , NULL , TRUE );
	if ( ( device < 0 ) || ( device >= 8 ) )
	{
		MessageBox( "Device must be between 0 and 7" , "Device Number Error" , MB_OK | MB_ICONEXCLAMATION );
		return;
	}
	// Assign node id and device.
	gCfg.byCom20020NodeID = node_id;
	gDeviceNumber = device;
	// Assign data rate.
	gDataRate = m_DataRate.GetCurSel();
	// Assign extended timeouts.
	gTimeouts = m_Timeouts.GetCurSel();
	// Receive all.
	gCfg.bCom20020ReceiveAll = m_ReceiveAll.GetCheck();
	// 128 Naks.
	gCfg.bCom20020_128NAKs = m_128Naks.GetCheck();

	CDialog::OnOK();
}

BOOL CLocalDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetDlgItemInt( IDC_NODEID , gCfg.byCom20020NodeID , TRUE );
	SetDlgItemInt( IDC_DEVICE , gDeviceNumber , TRUE );
	m_DataRate.SetCurSel( gDataRate );
	m_Timeouts.SetCurSel( gTimeouts );
	m_ReceiveAll.SetCheck( gCfg.bCom20020ReceiveAll );
	m_128Naks.SetCheck( gCfg.bCom20020_128NAKs );
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
