#!/bin/sh
#
# Here to reload applications.
#
# Need unit and server IP addresses as parameters.
#

# Must already have apps.tgz in /tmp.
if [ ! -e /tmp/apps.tgz ]
then
	echo "Need /tmp/apps.tgz"
	exit 1
fi

echo "Killing all applications..."
/app/scripts/kill-apps.sh

echo "Starting at root..."
cd /

echo "Making file system read-write..."
/scripts/read-write.sh

echo "Removing some existing files..."
rm -rf /app/www/*
rm -rf /app/bin/*

echo "Unpacking application tarball..."
tar -xvzf /tmp/apps.tgz

echo "Removing tarball..."
rm /tmp/apps.tgz

echo "Done!"
exit 0
