package ConfigUnit;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

import modbus.mod;
import bas_remote.bas_cfg_t;
import bas_remote.bas_def;

public class ConfigUnitJApplet extends JApplet
{
	private JTextField EbxMstpNetwork;
	private JTextField EbxSysReadDelay;
	private JTextField EbxOflPollDelay;
	private JTextField EbxModPollDelay;
	private JTextField EbxTimeout;
	private JComboBox CbxParity;
	private JComboBox CbxProtocol;
	private JComboBox CbxBaudrate;
	private JTextField EbxTimeToLive;
	private JTextField EbxBbmdAddress;
	private JTextField EbxUdpPort;
	private JTextField EbxDevInstance;
	private JTextField EbxGateway;
	private JTextField EbxSubnetMask;
	private JTextField EbxIpAddress;
	private JTextField EbxSystemName;
	private JLabel 		LblError;
	private JButton 	BnUpdateCfg;
	    
	/**
	    * Member variables.
	    */
		private String             hostAddress;
	    static boolean             dbug_on             = false;
	    static String              dbug_ip             = "192.168.92.150";
	    static int                 dbug_unit           = 1;
	    //
	    private mod.device         comBas              = new mod.device();
	    //    
	    bas_cfg_t                  bas_cfg             = new bas_cfg_t();
	    bas_cfg_t                  temp_cfg            = new bas_cfg_t();
	    //
	    int                        exp_unit_qty;
	    //
	    Timer                      err_tmr;
	    TimerTask                  err_tmr_task;
	    int                        err_tmr_cnt;
	    //
	    private boolean            applet_running      = true;
	    private ConnectTask        connect_task        = new ConnectTask();
	    //
	    private boolean            update_in_process   = false;

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		public ConfigUnitJApplet() 
		{
			super();
	        initComponents();

			final JLabel afterChangingALabel = new JLabel();
			afterChangingALabel.setText("After changing a System or Modbus setting, press Reboot.");
			afterChangingALabel.setBounds(21, 741, 436, 14);
			getContentPane().add(afterChangingALabel);
		}
		
	    public void init()
	    {
	        // Get code base string.
	        hostAddress = this.getCodeBase().toString().toLowerCase();
	        // If forcing the address.
	        if (dbug_on == true)
	            hostAddress = dbug_ip;
	        // Else if executing from local machine.
	        else if (hostAddress.startsWith("file"))
	            hostAddress = "localhost";
	        // Else for real.
	        else
	        {
	            hostAddress = hostAddress.replace("http://", " ");
	            hostAddress = hostAddress.replace("/", " ").trim();
	        }
	        // Connect with host.
	        comBas.Connect(hostAddress, mod.def.PORT_TCP, mod.def.PROT_TCP);
	        if (!comBas.IsConnected())
	        {
	            LblError.setText("Cannot connect to target");
	        }

	        // System and virtual point data.
	        try
	        {
	            getSystemData();
	        } catch (IOException e)
	        {
	            comBas.Disconnect();
	            // Disable update button.
	            BnUpdateCfg.setEnabled(false);
	        }

	        // Turn off error indication.
	        LblError.setVisible(false);

	        // Create timer and task.
	        err_tmr = new Timer();
	        err_tmr_task = new TimerTask()
	        {
	            public void run()
	            {
	                CheckErrorLabel();
	            }
	        };
	        // Set timer to start after 1 second with 1 second interval.
	        err_tmr.scheduleAtFixedRate(err_tmr_task, 1000, 1000);

	        // Start connect task.
	        connect_task.execute();
	    }

	    public void destroy()
	    {
	        comBas.Disconnect();
	    }

	    /**
	     * This thread operates in the background to try and re-establish the link
	     * with the host should it be broken.
	     * 
	     * @author rcw
	     * 
	     */
	    public class ConnectTask extends SwingWorker<Void, Void>
	    {
	        @Override
	        public Void doInBackground()
	        {
	            while (applet_running)
	            {
	                if (!comBas.IsConnected())
	                {
	                    comBas.Connect(hostAddress, mod.def.PORT_TCP, mod.def.PROT_TCP);
	                    if (comBas.IsConnected())
	                    {
	                        try
	                        {
	                            getSystemData();
	                            // Enable update button.
	                            // Clear flag.
	                            update_in_process = false;
	                        }
	                        catch (IOException e)
	                        {
	                            comBas.Disconnect();
	                        }
	                    }
	                }
	                try
	                {
	                    Thread.sleep(2000);
	                } catch (InterruptedException e)
	                {
	                }
	            }
	            return null;
	        }
	    }

	    private void getSystemData() throws IOException
	    {
	    	String		tmp;
	    	int			baudIndx = 0;
	        // Return if not connected.
	        if (!comBas.IsConnected())
	        {
	            IOException e = new IOException("Target not connected");
	            throw e;
	        }
	        // Use try/catch.
	        try
	        {
	            // Get the system name.
	            EbxSystemName.setText(comBas.ReadCfgStr(bas_def.REG_SYS_NAME));

	            // Get the system IP address.
	            EbxIpAddress.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR)));

	            // Get the system Subnet Mask.
	            EbxSubnetMask.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_NETMASK)));

	            // Get the system Gateway.
	            EbxGateway.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_GATEWAY)));
	            //
	            // Modbus interface data.
	            //
	            // Baudrate.
	            baudIndx = comBas.ReadCfgInt(bas_def.REG_SYS_BAUDRATE);
	            if(baudIndx == 7)
	            	baudIndx = 6;
	            CbxBaudrate.setSelectedIndex(baudIndx);
	            // Protocol.            
	            CbxProtocol.setSelectedIndex(comBas.ReadCfgInt(bas_def.REG_SYS_PROTOCOL));
	            // Parity.          
	            CbxParity.setSelectedIndex(comBas.ReadCfgInt(bas_def.REG_SYS_PARITY));
	            //
	            // NOTE: We are now using milliseconds in the applet display.
	            //
	            // Timeout.
	            EbxTimeout.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_TIMEOUT)));
	            // Modbus poll delay.
	            EbxModPollDelay.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_POLL_MCD)));
	            // Offline poll delay.
	            EbxOflPollDelay.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_POLL_OFFLINE)));
	            // System poll delay.
	            EbxSysReadDelay.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_READ_DELAY)));
	            //
	            // Bacnet data.
	            //
	            // Bacnet device instance.
	            EbxDevInstance.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_BAC_INSTANCE)));
	            // Bacnet udp port; displayed in hex, stored in decimal.
	            tmp = comBas.ReadCfgStr(bas_def.REG_SYS_BAC_UDP_PORT);
	            int   udp_port = Integer.decode(tmp);
	            String udp_str = Integer.toHexString(udp_port);
	            EbxUdpPort.setText("0x" + udp_str.toUpperCase());
	            // Bacnet bbmd ip address.
	            EbxBbmdAddress.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_BAC_BBMD_IP)));
	            // Bacnet time to live.
	            EbxTimeToLive.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_BAC_TTL)));
	            // Bacnet mstp network number
	            EbxMstpNetwork.setText((tmp = comBas.ReadCfgStr(bas_def.REG_SYS_BAC_MSTP_NETWORK)));
	        } catch (IOException e)
	        {
	            throw e;
	        }
	    }

	    public void ProcessError( String text )
	    {
	        mod.err e = mod.err.getObj(text);

	        switch (e)
	        {
	            // We ignore ILLEGAL errors here.
	            case ILLEGAL_DATA_ADDRESS:
	            case ILLEGAL_FUNCTION:
	            case ILLEGAL_DATA_VALUE:
	            case ILLEGAL_OBJECT_INSTANCE:
	                break;
	            default:
	                comBas.Disconnect();
	                break;
	        }
	        DisplayError(text);
	    }

	    public void DisplayError( String err )
	    {
	        LblError.setText(err);
	        LblError.setVisible(true);
	        // Disable update button.
	        BnUpdateCfg.setEnabled(false);
	    }

	    // Clear error text after 3 seconds, or set counter
	    // when error is detected.
	    //
	    void CheckErrorLabel()
	    {
	        // If error counter is not zero.
	        if (err_tmr_cnt != 0)
	        {
	            // Decrement it.
	            --err_tmr_cnt;
	            // If it just went to zero.
	            if (err_tmr_cnt == 0)
	            {
	                // Restore original error text.
	                LblError.setText("ERROR");
	                // Turn off error indicator.
	                LblError.setVisible(false);
	                // Re-enable update button if we're connected.
	                if ( comBas.IsConnected() )
	                {
	                    // Enable update button.
	                    // Clear flag.
	                    update_in_process = false;
	                }
	            }
	            return;
	        }
	        // If error has occurred.
	        if (LblError.isVisible() == true)
	        {
	            // Initialize counter for 3 seconds.
	            err_tmr_cnt = 3;
	        }
	    }

	    int validateIPAddress( int j )
	    {
	        int k;
	        String[] temp = null;
	        String ip;

	        switch (j)
	        {
	            case 0: // IP
	                ip = EbxIpAddress.getText();
	                break;

	            case 1: // subnet mask
	                ip = EbxSubnetMask.getText();
	                break;

	            case 2: // gateway
	                ip = EbxGateway.getText();
	                break;

	            case 3: // BBMD ip address.
	                ip = EbxBbmdAddress.getText();
	                break;

	            default:
	                return -1;
	        }

	        // Do the split.
	        temp = ip.split("\\.");

	        // should have 4 values
	        if (temp.length < 4)
	            return -1;

	        // no whitespace allowed
	        for (k = 0; k < 4; k++)
	        {
	            if (temp[k].length() != temp[k].trim().length())
	                return -1;
	        }

	        if ((temp[0].length() == 0) || (temp[1].length() == 0) || (temp[2].length() == 0) || (temp[3].length() == 0))
	            return -1;

	        // valid range is 0 to 255
	        for (k = 0; k < 4; k++)
	        {
	            if ((Integer.valueOf(temp[k]).intValue() < 0) || (Integer.valueOf(temp[k]).intValue() > 255))
	                return -1;
	        }

	        // check subnet mask for all zeros
	        if (j == -1)
	        {
	            for (k = 0; k < 4; k++)
	            {
	                if (Integer.valueOf(temp[k]).intValue() > 0)
	                {
	                    j = 0;
	                    break;
	                }
	            }
	        }

	        return j;
	    }


	    private void updateCfg()
	    {
	        int 	i;
            int		baudIndex = 0;
	        
	        // Ignore this if already updating.
	        if ( update_in_process )
	            return;
	        
	        // Set flag. We'll reset this flag at the end of the update,
	        // or whenever an error condition is cleared.
	        update_in_process = true;

	        // Get device Instance value and check range
	        i = Integer.decode(EbxDevInstance.getText());

	        if ((i < 0) || (i > 4194302))
	        {
	            EbxDevInstance.requestFocusInWindow();
	            LblError.setVisible(true);
	            return;
	        }

	        // validate IP address
	        if (validateIPAddress(0) < 0)
	        {
	            EbxIpAddress.requestFocusInWindow();
	            LblError.setVisible(true);
	            return;
	        }

	        // validate subnet mask
	        if (validateIPAddress(1) < 0)
	        {
	            EbxSubnetMask.requestFocusInWindow();
	            LblError.setVisible(true);
	            return;
	        }

	        // validate Gateway Address
	        if (validateIPAddress(2) < 0)
	        {
	            EbxGateway.requestFocusInWindow();
	            LblError.setVisible(true);
	            return;
	        }

	        // Validate bacnet bbmd ip address.
	        if (validateIPAddress(3) < 0)
	        {
	            EbxBbmdAddress.requestFocusInWindow();
	            LblError.setVisible(true);
	            return;
	        }

	        // Check timing values.
	        i = Integer.decode(EbxModPollDelay.getText());
	        if ((i < 100) || (i > 30000))
	        {
	            EbxModPollDelay.requestFocusInWindow();
	            LblError.setText("Time value out of range (100<>30000)");
	            LblError.setVisible(true);
	            return;
	        }
	        i = Integer.decode(EbxOflPollDelay.getText());
	        if ((i < 2000) || (i > 30000))
	        {
	            EbxOflPollDelay.requestFocusInWindow();
	            LblError.setText("Time value out of range (2000<>30000)");
	            LblError.setVisible(true);
	            return;
	        }
	        i = Integer.decode(EbxSysReadDelay.getText());
	        if ((i < 0) || (i > 1000))
	        {
	        	EbxSysReadDelay.requestFocusInWindow();
	            LblError.setText("Time value out of range (0<>1000)");
	            LblError.setVisible(true);
	            return;
	        }

	        i = Integer.decode(EbxTimeout.getText());
	        if ((i < 50) || (i > 3000))
	        {
	            EbxTimeout.requestFocusInWindow();
	            LblError.setText("Time value out of range (50<>3000)");
	            LblError.setVisible(true);
	            return;
	        }

	        // Use try/catch.
	        try
	        {
	            // ---------------------------------------------------------------------
	            // Take unit offline; error if we can't.
	            comBas.WriteCfg(bas_def.REG_SYS_OFFLINE, "1");
	            // ---------------------------------------------------------------------
	            // System configuration.
	            // ---------------------------------------------------------------------

	            // System name.
	            try
	            {
	                comBas.WriteCfg(bas_def.REG_SYS_NAME, EbxSystemName.getText());
	            } catch (IOException e)
	            {
	                EbxSystemName.requestFocusInWindow();
	                ProcessError(e.getMessage());
	                return;
	            }
	            // System IP address.
	            if (comBas.WriteCfg(bas_def.REG_SYS_IPADDR, EbxIpAddress.getText()) != 0)
	            {
	                EbxIpAddress.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }
	            // System subnet mask.
	            if (comBas.WriteCfg(bas_def.REG_SYS_NETMASK, EbxSubnetMask.getText()) != 0)
	            {
	                EbxSubnetMask.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }
	            // System gateway address.
	            if (comBas.WriteCfg(bas_def.REG_SYS_GATEWAY, EbxGateway.getText()) != 0)
	            {
	                EbxGateway.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }

	            // ---------------------------------------------------------------------
	            // Bacnet configuration.
	            // ---------------------------------------------------------------------

	            // Bacnet device instance.
	            if (comBas.WriteCfg(bas_def.REG_SYS_BAC_INSTANCE, EbxDevInstance.getText()) != 0)
	            {
	                EbxDevInstance.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }
	            // Bacnet udp port; displayed in hex, stored in decimal.
	            int udp_port = Integer.decode(EbxUdpPort.getText());
	            if (comBas.WriteCfg(bas_def.REG_SYS_BAC_UDP_PORT, Integer.toString(udp_port)) != 0)
	            {
	                EbxUdpPort.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }
	            // Bacnet bbmd ip address.
	            if (comBas.WriteCfg(bas_def.REG_SYS_BAC_BBMD_IP, EbxBbmdAddress.getText()) != 0)
	            {
	                EbxBbmdAddress.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }
	            // Bacnet time to live.
	            if (comBas.WriteCfg(bas_def.REG_SYS_BAC_TTL, EbxTimeToLive.getText()) != 0)
	            {
	                EbxTimeToLive.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }           
	            // BACnet MS/TP Network Number
	            if (comBas.WriteCfg(bas_def.REG_SYS_BAC_MSTP_NETWORK, EbxMstpNetwork.getText()) != 0)
	            {
	            	EbxMstpNetwork.requestFocusInWindow();
	                LblError.setVisible(true);
	                return;
	            }           

	            // ---------------------------------------------------------------------
	            // Modbus configuration.
	            // ---------------------------------------------------------------------
	            baudIndex = CbxBaudrate.getSelectedIndex();
	            if(baudIndex == 6)
	            	baudIndex = 7;
	            // Baudrate.
	            comBas.WriteCfg(bas_def.REG_SYS_BAUDRATE, Integer.toString(baudIndex));
	            // Protocol.
	            comBas.WriteCfg(bas_def.REG_SYS_PROTOCOL, Integer.toString(CbxProtocol.getSelectedIndex()));
	            // Parity.
	            comBas.WriteCfg(bas_def.REG_SYS_PARITY, Integer.toString(CbxParity.getSelectedIndex()));
	            //
	            // NOTE: We are now using milliseconds in the applet display.
	            //
	            // Timeout.
	            comBas.WriteCfg(bas_def.REG_SYS_TIMEOUT, EbxTimeout.getText());
	            // Modbus polling delay.
	            comBas.WriteCfg(bas_def.REG_SYS_POLL_MCD, EbxModPollDelay.getText());
	            // Offline polling delay.
	            comBas.WriteCfg(bas_def.REG_SYS_POLL_OFFLINE, EbxOflPollDelay.getText());
	            // Consecutive read delay.
	            comBas.WriteCfg(bas_def.REG_SYS_READ_DELAY, EbxSysReadDelay.getText());
	            // ---------------------------------------------------------------------
	            // Save new configuration.
	            // Extend timeout for this operation, then reset to default value.
	            //comBas.SetTimeout(15000);
	            comBas.SetTimeout(15000);
	            comBas.WriteCfg(bas_def.REG_SYS_FCN, bas_def.FCN_COMMIT);
	            comBas.SetTimeout(-1);
	            // Clear flag.
	            update_in_process = false;
	        } catch (IOException e)
	        {
	            ProcessError(e.getMessage());
	        }
	    }

	    private void initComponents()
	    {
			getContentPane().setLayout(null);

			final JLabel systemLabel = new JLabel();
			systemLabel.setForeground(Color.RED);
			systemLabel.setFont(new Font("Sans", Font.BOLD, 20));
			systemLabel.setText("System");
			systemLabel.setBounds(21, 23, 90, 26);
			getContentPane().add(systemLabel);

			final JLabel systemNameLabel = new JLabel();
			systemNameLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			systemNameLabel.setText("System Name:");
			systemNameLabel.setBounds(21, 72, 104, 14);
			getContentPane().add(systemNameLabel);

			EbxSystemName = new JTextField();
			EbxSystemName.setFont(new Font("Sans", Font.PLAIN, 12));
			EbxSystemName.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxSystemName.setText("EbxSystemName");
			EbxSystemName.setBounds(146, 70, 160, 18);
			getContentPane().add(EbxSystemName);

			final JLabel ipAddressLabel = new JLabel();
			ipAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			ipAddressLabel.setText("IP Address:");
			ipAddressLabel.setBounds(21, 96, 104, 14);
			getContentPane().add(ipAddressLabel);

			EbxIpAddress = new JTextField();
			EbxIpAddress.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxIpAddress.setText("EbxIpAddress");
			EbxIpAddress.setBounds(146, 94, 160, 18);
			getContentPane().add(EbxIpAddress);

			final JLabel subnetMaskLabel = new JLabel();
			subnetMaskLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			subnetMaskLabel.setText("Subnet Mask:");
			subnetMaskLabel.setBounds(21, 120, 104, 14);
			getContentPane().add(subnetMaskLabel);

			EbxSubnetMask = new JTextField();
			EbxSubnetMask.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxSubnetMask.setText("EbxSubnetMask");
			EbxSubnetMask.setBounds(146, 118, 160, 18);
			getContentPane().add(EbxSubnetMask);

			final JLabel gatewayAddressLabel = new JLabel();
			gatewayAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			gatewayAddressLabel.setText("Gateway Address:");
			gatewayAddressLabel.setBounds(21, 143, 118, 14);
			getContentPane().add(gatewayAddressLabel);

			EbxGateway = new JTextField();
			EbxGateway.setText("EbxGateway");
			EbxGateway.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxGateway.setBounds(146, 142, 160, 18);
			getContentPane().add(EbxGateway);

			final JLabel bacnetLabel = new JLabel();
			bacnetLabel.setForeground(Color.RED);
			bacnetLabel.setFont(new Font("Sans", Font.BOLD, 20));
			bacnetLabel.setText("BACnet");
			bacnetLabel.setBounds(21, 186, 90, 18);
			getContentPane().add(bacnetLabel);

			final JLabel deviceInstanceLabel = new JLabel();
			deviceInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			deviceInstanceLabel.setText("Device Instance:");
			deviceInstanceLabel.setBounds(21, 234, 104, 14);
			getContentPane().add(deviceInstanceLabel);

			EbxDevInstance = new JTextField();
			EbxDevInstance.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxDevInstance.setText("EbxDevInstance");
			EbxDevInstance.setBounds(146, 232, 160, 18);
			getContentPane().add(EbxDevInstance);

			final JLabel udpPortLabel = new JLabel();
			udpPortLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			udpPortLabel.setText("UDP Port:");
			udpPortLabel.setBounds(21, 258, 77, 14);
			getContentPane().add(udpPortLabel);

			EbxUdpPort = new JTextField();
			EbxUdpPort.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxUdpPort.setText("EbxUdpPort");
			EbxUdpPort.setBounds(146, 256, 160, 18);
			getContentPane().add(EbxUdpPort);

			final JLabel bbmdAddressLabel = new JLabel();
			bbmdAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			bbmdAddressLabel.setText("BBMD IP Address:");
			bbmdAddressLabel.setBounds(21, 282, 118, 14);
			getContentPane().add(bbmdAddressLabel);

			EbxBbmdAddress = new JTextField();
			EbxBbmdAddress.setText("EbxBbmdAddress");
			EbxBbmdAddress.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxBbmdAddress.setBounds(146, 280, 160, 18);
			getContentPane().add(EbxBbmdAddress);

			final JLabel bbmdRegTimeLabel = new JLabel();
			bbmdRegTimeLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			bbmdRegTimeLabel.setText("BBMD Reg Time:");
			bbmdRegTimeLabel.setBounds(21, 309, 104, 16);
			getContentPane().add(bbmdRegTimeLabel);

			EbxTimeToLive = new JTextField();
			EbxTimeToLive.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxTimeToLive.setText("EbxTimeToLive");
			EbxTimeToLive.setBounds(146, 307, 160, 18);
			getContentPane().add(EbxTimeToLive);

			final JLabel modbusLabel = new JLabel();
			modbusLabel.setForeground(Color.RED);
			modbusLabel.setFont(new Font("Sans", Font.BOLD, 20));
			modbusLabel.setText("Modbus");
			modbusLabel.setBounds(21, 381, 90, 26);
			getContentPane().add(modbusLabel);

			final JLabel baudrateLabel = new JLabel();
			baudrateLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			baudrateLabel.setText("Baudrate:");
			baudrateLabel.setBounds(21, 434, 65, 14);
			getContentPane().add(baudrateLabel);

			final JLabel protocolLabel = new JLabel();
			protocolLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			protocolLabel.setText("Protocol:");
			protocolLabel.setBounds(21, 466, 77, 14);
			getContentPane().add(protocolLabel);

			final JLabel parityLabel = new JLabel();
			parityLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			parityLabel.setText("Parity:");
			parityLabel.setBounds(21, 496, 58, 14);
			getContentPane().add(parityLabel);

			final JLabel commandTimeoutLabel = new JLabel();
			commandTimeoutLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			commandTimeoutLabel.setText("Command Timeout:");
			commandTimeoutLabel.setBounds(21, 524, 118, 14);
			getContentPane().add(commandTimeoutLabel);

			final JLabel interScanDelayLabel = new JLabel();
			interScanDelayLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			interScanDelayLabel.setText("Inter Scan Delay:");
			interScanDelayLabel.setBounds(21, 545, 104, 18);
			getContentPane().add(interScanDelayLabel);

			final JLabel offlinePollPeriodLabel = new JLabel();
			offlinePollPeriodLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			offlinePollPeriodLabel.setText("Offline Poll Period:");
			offlinePollPeriodLabel.setBounds(21, 569, 118, 18);
			getContentPane().add(offlinePollPeriodLabel);

			final JLabel consecutiveReadDelayLabel = new JLabel();
			consecutiveReadDelayLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			consecutiveReadDelayLabel.setText("Consecutive RD Delay:");
			consecutiveReadDelayLabel.setBounds(21, 597, 160, 14);
			getContentPane().add(consecutiveReadDelayLabel);

			CbxBaudrate = new JComboBox();
			CbxBaudrate.setFont(new Font("Sans", Font.PLAIN, 10));
			CbxBaudrate.setModel(new DefaultComboBoxModel(new String[] {"2400", "4800", "9600", "19200", "38400", "57600", "115200"}));
			CbxBaudrate.setBorder(new BevelBorder(BevelBorder.LOWERED));
			CbxBaudrate.setBounds(181, 429, 90, 26);
			getContentPane().add(CbxBaudrate);

			CbxProtocol = new JComboBox();
			CbxProtocol.setFont(new Font("Sans", Font.PLAIN, 10));
			CbxProtocol.setModel(new DefaultComboBoxModel(new String[] {"Modbus ASCII", "Modbus RTU"}));
			CbxProtocol.setBorder(new BevelBorder(BevelBorder.LOWERED));
			CbxProtocol.setBounds(181, 461, 144, 26);
			getContentPane().add(CbxProtocol);

			CbxParity = new JComboBox();
			CbxParity.setBorder(new BevelBorder(BevelBorder.LOWERED));
			CbxParity.setModel(new DefaultComboBoxModel(new String[] {"NONE", "EVEN", "ODD"}));
			CbxParity.setFont(new Font("Sans", Font.PLAIN, 10));
			CbxParity.setBounds(181, 493, 88, 23);
			getContentPane().add(CbxParity);

			EbxTimeout = new JTextField();
			EbxTimeout.setText("EbxTimeout");
			EbxTimeout.setBounds(181, 522, 144, 18);
			getContentPane().add(EbxTimeout);

			EbxModPollDelay = new JTextField();
			EbxModPollDelay.setText("EbxModPollDelay");
			EbxModPollDelay.setBounds(181, 546, 144, 18);
			getContentPane().add(EbxModPollDelay);

			EbxOflPollDelay = new JTextField();
			EbxOflPollDelay.setText("EbxOflPollDelay");
			EbxOflPollDelay.setBounds(181, 570, 144, 18);
			getContentPane().add(EbxOflPollDelay);

			EbxSysReadDelay = new JTextField();
			EbxSysReadDelay.setText("EbxSysReadDelay");
			EbxSysReadDelay.setBounds(181, 595, 144, 18);
			getContentPane().add(EbxSysReadDelay);

			final JLabel mstpNetworkLabel = new JLabel();
			mstpNetworkLabel.setFont(new Font("Sans", Font.PLAIN, 12));
			mstpNetworkLabel.setText("Virtual Network:");
			mstpNetworkLabel.setBounds(21, 333, 104, 14);
			getContentPane().add(mstpNetworkLabel);

			EbxMstpNetwork = new JTextField();
			EbxMstpNetwork.setText("EbxMstpNetwork");
			EbxMstpNetwork.setBorder(new BevelBorder(BevelBorder.LOWERED));
			EbxMstpNetwork.setBounds(146, 331, 160, 18);
			getContentPane().add(EbxMstpNetwork);
			
			LblError = new JLabel();
			LblError.setFont(new Font("Sans", Font.BOLD, 14));
			LblError.setForeground(Color.RED);
			LblError.setText("Cannot connect to target");
			LblError.setBounds(21, 646, 318, 14);
			getContentPane().add(LblError);

			BnUpdateCfg = new JButton();
			BnUpdateCfg.addActionListener(new ActionListener() {
				public void actionPerformed(final ActionEvent arg0) {
	                updateCfg();
				}
			});
			BnUpdateCfg.setText("Save");
			BnUpdateCfg.setBounds(21, 666, 122, 24);
			getContentPane().add(BnUpdateCfg);

			final JPanel notePanel = new JPanel();
			notePanel.setBorder(new TitledBorder(null, "NOTE", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, Color.BLACK));
			notePanel.setBounds(346, 524, 111, 87);
			getContentPane().add(notePanel);
			notePanel.setLayout(null);

			final JLabel allTimeLabel = new JLabel();
			allTimeLabel.setText("All Time");
			allTimeLabel.setBounds(10, 22, 77, 14);
			notePanel.add(allTimeLabel);

			final JLabel valuesInLabel = new JLabel();
			valuesInLabel.setText("Values in");
			valuesInLabel.setBounds(10, 42, 77, 14);
			notePanel.add(valuesInLabel);

			final JLabel millisecondsLabel = new JLabel();
			millisecondsLabel.setText("Milliseconds");
			millisecondsLabel.setBounds(10, 62, 94, 14);
			notePanel.add(millisecondsLabel);

			final JLabel rebootLabel = new JLabel();
			rebootLabel.setForeground(Color.RED);
			rebootLabel.setBounds(161, 713, 329, 14);
			getContentPane().add(rebootLabel);

			final JButton rebootButton = new JButton();
			rebootButton.addActionListener(new ActionListener() 
			{
				public void actionPerformed(final ActionEvent arg0) 
				{
					int		result = 0;
	                String	ip = null;
        			
	                try 
	                {
						ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
					} 
	                catch (IOException e) 
	                {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
	                if(ip == null)
	                {
						rebootLabel.setText("Reboot failed, IP address not reachable");	                	
	                }
	                else
	                {
	                	result = writeFlagFile.writeResetFlagFile(ip, "root", "ccsi2431");
	                	if(result < 0)
	                		rebootLabel.setText("Reboot failed, recycle power manually");
	                	else
		                	rebootLabel.setText("Please wait for 30 sec for rebooting");
	                }
				}
			});
			rebootButton.setText("Reboot");
			rebootButton.setBounds(21, 708, 122, 24);
			getContentPane().add(rebootButton);
}
	}
