package MappingCfg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;

import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class fileFunction 
{
	static int		unit_qty;
	static int		reg_qty;
	static int		template_qty;
	static int[]	reg_status;
	static String	unit_instance;
	static String	mod_address;
	static String	mod_ip;
	static String	unit_name;
	static String	devType;
	static String[]	registers;
	static String[] description;
	static String[]	template_filename;
	static String[]	template_type;
	static String[]	modbusAddr;
	static String	consecutive_rd;
	static int[]	devInstance;
	static int		unit_index;
	static int		total_reg_qty;
	
	final static int	MAX_DEV = 30;
	final static int	MAX_OBJ = 1000;
	final static int	MAX_RD	= 125;
	
	public static void init()
	{
		unit_qty = 0;
		reg_status = new int[MAX_OBJ];
		registers = new String[MAX_OBJ];
		description = new String[MAX_OBJ];		
		modbusAddr = new String[MAX_DEV];
		devInstance = new int[MAX_DEV];
		unit_index = 0;
		total_reg_qty = 0;
	}
	
	public static FTPClient getFtpClient(String ip , String user , String password)
    {
		int reply;
		FTPClient ftp = new FTPClient();

		try
		{
			// Connect to target.
			ftp.connect(ip);

			// After connection attempt, you should check the reply code to
			// verify success.
			reply = ftp.getReplyCode();
			if (!FTPReply.isPositiveCompletion(reply))
			{
				ftp.disconnect();
				System.err.println("FTP server refused connection.");
				ftp = null;
			}
			else
			{
				// Log in.
				ftp.login(user, password);
			}
		} catch (IOException e)
		{
			ftp = null;
			e.printStackTrace();
		}
		// Failure if we get here.
		return ftp;
    }

	//
	//#########################################################
	// Template CSV File Functions.
	//#########################################################
	//
    public static int readTemplateCSVFile( InputStream csvStream)
    {
    	InputStreamReader	inReader = null;
    	BufferedReader		buf = null;   	
		String 				strLine = "";
		StringTokenizer 	st = null;
		int 				lineNumber = 0, tokenNumber = 0;
		String				status;
		
		try
		{
			inReader = new InputStreamReader(csvStream);
			buf = new BufferedReader(inReader);
			//read comma separated file line by line
			while( (strLine = buf.readLine()) != null)
			{
				lineNumber++;
				if(lineNumber == 1)		
					continue;
				if(lineNumber > (MAX_OBJ + 1))
					break;
				//break comma separated line using ","
				st = new StringTokenizer(strLine, ",");
				while(st.hasMoreTokens())
				{
					//display csv values
					tokenNumber++;
					status = st.nextToken();
					if(tokenNumber == 1)
					{
						if(status.equals("YES"))
							reg_status[lineNumber - 2] = 1;
						else
							reg_status[lineNumber - 2] = 0;
					}
					if(tokenNumber == 3)
					{
						description[lineNumber - 2] = status.substring(1);											
					}
					if(tokenNumber == 5)
					{
						registers[lineNumber - 2] = status.substring(1);						
						break;
					}
				}
				//reset token number
				tokenNumber = 0;
			}
			reg_qty = lineNumber - 1;
			if(reg_qty > MAX_OBJ)
				reg_qty = MAX_OBJ;
		}
		catch(Exception e)
		{
			System.out.println("Exception while reading csv file: " + e);	
			return -1;
		}
    	return 0;
    }
    
    public static int getTemplateCSVFile( String ip , String user , String password , String filename )
	{
		FTPClient 		ftp;
		InputStream 	is = null;
		boolean			error = false;
		// Get ftp client.
		ftp = getFtpClient(ip, user, password);
		// If successful.
		if (ftp != null)
		{
			ftp.enterLocalPassiveMode();
			try
			{
				// Get input stream.
				is = ftp.retrieveFileStream(filename);
    			// If valid input stream.
    			if (is != null)
    			{
    				// Get document.
    				readTemplateCSVFile(is);
	    			// Close stream.
	    			is.close();
    			}
    			else
    				error = true;
			} 
			catch (IOException e)
			{
                e.printStackTrace();
                error = true;
			}
			finally
			{
				if (ftp.isConnected())
				{
					try
					{
		    			ftp.logout();
						ftp.disconnect();
					} 
					catch (IOException ioe)
					{
						error = true;
					}
				}
				ftp = null;
			}
		}
		else
			error = true;
		
		if(error == true)
			return -1;
		
		return 0;
	}

	//
	//#########################################################
	// User CSV File Functions
	//#########################################################
	//
    public static int copyTemplateToUserCSVFile( String ip , String user , String password , String src, String dst )
	{
		FTPClient 			ftp;
		InputStream 		is = null;
		OutputStream		os = null;
    	InputStreamReader	inReader = null;
    	BufferedReader		buf = null;   	
		String 				strLine = "";
		int 				lineNumber = 0, index = 0;
		Writer 				outWriter;
		BufferedWriter 		out;
		StringBuffer		strBuf = null;
		boolean				error = false;
		
		// Get ftp client.
		ftp = getFtpClient(ip, user, password);
		// If successful.
		if (ftp != null)
		{
			ftp.enterLocalPassiveMode();
			try
			{
				strBuf = new StringBuffer();
				// Get input stream.
				is = ftp.retrieveFileStream(src);
    			// If valid input and output stream.
    			if (is != null)
    			{
    				inReader = new InputStreamReader(is);
    				buf = new BufferedReader(inReader);
    				// modify the old parameters
    				//read comma separated file line by line
    				while( (strLine = buf.readLine()) != null)
    				{
    					if(lineNumber > 0)
    					{
    						if(reg_status[lineNumber - 1] == 1)
    						{
    							index = strLine.indexOf("NO");
    							if(index == 0)
    								strLine = strLine.replaceFirst("NO", "YES");
    						}
    						else
    						{
    							index = strLine.indexOf("YES");
    							if(index == 0)
    								strLine = strLine.replaceFirst("YES", "NO");    						
    						}
    					}
    					strBuf.append(strLine);
        				strBuf.append('\n');
    					lineNumber++;
    					if(lineNumber >= (MAX_OBJ + 1))
    						break;
    				}
    				reg_qty = lineNumber - 1;
    		    	if(reg_qty > MAX_OBJ)
    		    		reg_qty = MAX_OBJ;
	    			// Close stream.
	    			is.close();
    			}
    			else
    				error = true;
			}
    		catch (IOException e)
    		{
    			error = true;
    			e.printStackTrace();
    		}    			
    		finally
    		{
    			if (ftp.isConnected())
    			{
    				try
    				{
    		    		ftp.logout();
    					ftp.disconnect();
    				} 
    				catch (IOException ioe)
    				{
    					error = true;
    				}
    			}
    			ftp = null;
    		}
		}
		else
			error = true;
			
		if(error == true)
			return -1;
		
    	ftp = getFtpClient(ip, user, password);
    	// If successful.
    	if (ftp != null)
    	{
			ftp.enterLocalPassiveMode();
    		try
    		{
    			// Get output stream
    			os = ftp.storeFileStream(dst);
    			if(os!= null)
    			{
    				outWriter = new OutputStreamWriter(os);
    				out = new BufferedWriter(outWriter);
    				// write new parameters in the file
    				out.write(unit_instance + ',' + consecutive_rd);
    				out.newLine();
    				out.write(unit_name);
    				out.newLine();
    				out.write(mod_address);
    				out.newLine();
    				out.write(mod_ip);
    				out.newLine();
    				//
    				out.write(strBuf.toString());
    				out.flush();
    				out.close();
        			os.close();
    			}
    			else
    				error = true;
    		} 
    		catch (IOException e)
    		{
    			error = true;
    			e.printStackTrace();
    		}
    		finally
    		{
    			if (ftp.isConnected())
    			{
    				try
    				{
    					ftp.logout();
    					ftp.disconnect();
    				} 
    				catch (IOException ioe)
    				{
    					error = true;
    				}
    			}
    			ftp = null;
    		}
    	}
    	else
    		error = true;
    	
    	if(error == true)
    		return -1;
    	
    	return 0;
	}
    
    public static int readUserCSVFile( InputStream csvStream)
    {
    	InputStreamReader	inReader = null;
    	BufferedReader		buf = null;   	
		String 				strLine = "";
		StringTokenizer 	st = null;
		int 				lineNumber = 0, tokenNumber = 0;
		String				status;
		
		try
		{
			inReader = new InputStreamReader(csvStream);
			buf = new BufferedReader(inReader);
			//read comma separated file line by line
			while( (strLine = buf.readLine()) != null)
			{
				lineNumber++;
				if(lineNumber == 1)
				{
					//break comma separated line using ","
					st = new StringTokenizer(strLine, ",");
					while(st.hasMoreTokens())
					{
						//display csv values
						tokenNumber++;
						status = st.nextToken();
						if(tokenNumber == 1)
						{
							unit_instance = status;
							consecutive_rd = "1";
						}
						else if(tokenNumber == 2)
						{
							consecutive_rd = status;
							break;
						}
					}
				}
				else if(lineNumber == 2)
					unit_name = strLine;
				else if(lineNumber == 3)
					mod_address = strLine;
				else if(lineNumber == 4)
					mod_ip = strLine;
				else if(lineNumber == 5)
					devType = strLine;
				else if(lineNumber > (MAX_OBJ + 5))
					break;
				else
				{
					tokenNumber = 0;
					//break comma separated line using ","
					st = new StringTokenizer(strLine, ",");
					while(st.hasMoreTokens())
					{
						//display csv values
						tokenNumber++;
						status = st.nextToken();
						if(tokenNumber == 1)
						{
							if(status.equals("YES"))
								reg_status[lineNumber - 6] = 1;
							else
								reg_status[lineNumber - 6] = 0;
						}
						if(tokenNumber == 3)
						{
							description[lineNumber - 6] = status.substring(1);											
						}
						if(tokenNumber == 5)
						{
							registers[lineNumber - 6] = status.substring(1);						
							break;
						}
					}
				}
				//reset token number
				tokenNumber = 0;
			}
			reg_qty = lineNumber - 5;
			if(reg_qty > MAX_OBJ)
				reg_qty = MAX_OBJ;
		}
		catch(Exception e)
		{
			System.out.println("Exception while reading csv file: " + e);	
			return -1;
		}
    	return 0;
    }

    public static int getUserCSVFile( String ip , String user , String password , String filename )
	{
		FTPClient 		ftp;
		InputStream 	is = null;
		boolean			error = false;
		
		// Get ftp client.
		ftp = getFtpClient(ip, user, password);
		// If successful.
		if (ftp != null)
		{
			ftp.enterLocalPassiveMode();
			try
			{
				// Get input stream.
				is = ftp.retrieveFileStream(filename);
    			// If valid input stream.
    			if (is != null)
    			{
    				// Get document.
    				readUserCSVFile(is);
	    			// Close stream.
	    			is.close();
    			}
    			else 
    				error = true;
			} 
			catch (IOException e)
			{
                e.printStackTrace();
                error = true;
			}
			finally
			{
				if (ftp.isConnected())
				{
					try
					{
		    			ftp.logout();
						ftp.disconnect();
					} 
					catch (IOException ioe)
					{
						error = true;
					}
				}
				ftp = null;
			}
		}
		else
			error = true;
		
		// And return.
		if(error == true)
			return -1;

		return 0;
	}

    public static int modifyUserCSVFile(String ip , String user , String password , String filename, String newfile)
	{
		FTPClient 			ftp;
		InputStream 		is = null;
		OutputStream		os = null;
    	InputStreamReader	inReader = null;
    	BufferedReader		buf = null;   	
		String 				strLine = "";
		int 				lineNumber = 0, index = 0;
		Writer 				outWriter;
		BufferedWriter 		out;
		StringBuffer		strBuf = null;
		boolean				error = false;
		
		// Get ftp client.
		ftp = getFtpClient(ip, user, password);
		// If successful.
		if (ftp != null)
		{
			strBuf = new StringBuffer();
			try
			{
				ftp.enterLocalPassiveMode();
				// Get input stream.
				is = ftp.retrieveFileStream(filename);
    			// If valid input stream.
    			if (is != null)
    			{
    				inReader = new InputStreamReader(is);
    				buf = new BufferedReader(inReader);
    				// write new parameters in the file
    				strBuf.append(unit_instance + ',' + consecutive_rd);
    				strBuf.append('\n');
    				strBuf.append(unit_name);
    				strBuf.append('\n');
    				strBuf.append(mod_address);
    				strBuf.append('\n');
    				strBuf.append(mod_ip);
    				strBuf.append('\n');
    				strBuf.append(devType);
    				strBuf.append('\n');
    				// modify the old parameters
    				//read comma separated file line by line
    				while( (strLine = buf.readLine()) != null)
    				{
    					lineNumber++;
    					if(lineNumber < 6)
    						continue;
    					if(lineNumber > (MAX_OBJ + 5))
    						break;
    					if(reg_status[lineNumber - 6] == 1)
    					{
    						index = strLine.indexOf("NO");
    						if(index == 0)
    							strLine = strLine.replaceFirst("NO", "YES");
    					}
    					else
    					{
    						index = strLine.indexOf("YES");
    						if(index == 0)
    							strLine = strLine.replaceFirst("YES", "NO");    						
    					}
    					strBuf.append(strLine);
        				strBuf.append('\n');
    				}
    				// Close stream.
    				is.close();
    			}
    			else
    				error = true;
			}
    		catch (IOException e)
    		{
    			error = true;
                e.printStackTrace();
    		}    			
    		finally
    		{
    			if (ftp.isConnected())
    			{
    				try
    				{
    		    		ftp.logout();
    					ftp.disconnect();
    				} 
    				catch (IOException ioe)
    				{
    					error = true;
    				}
    			}
    			ftp = null;
    		}
		}
		
		if(error == true)
			return -1;
		
		// Get output stream.
		// Get ftp client.
		ftp = getFtpClient(ip, user, password);
		// If successful.
		if (ftp != null)
		{
			ftp.enterLocalPassiveMode();
			try
			{
				if(newfile == null)
					os = ftp.storeFileStream(filename);
				else
					os = ftp.storeFileStream(newfile);
				if (os != null)
				{
					outWriter = new OutputStreamWriter(os);
					out = new BufferedWriter(outWriter);
					out.write(strBuf.toString());
					out.flush();
					out.close();
					// Close stream.
					os.close();
				}
				else
					error = true;
    		}
    		catch (IOException e)
    		{
    			error = true;
                e.printStackTrace();
    		}    			
    		finally
    		{
    			if (ftp.isConnected())
    			{
    				try
    				{
    		    		ftp.logout();
    					ftp.disconnect();
    				} 
    				catch (IOException ioe)
    				{
    					error = true;
    				}
    			}
    			ftp = null;
    		}
		}
		// And return.
		if(error == true)
			return -1;

		return 0;
	}

    // Delete a file 
    public static boolean delFile( String ip , String user , String password , String filename )
	{
		FTPClient 		ftp;
		boolean 		result = false;

		// Get ftp client.
		ftp = getFtpClient(ip, user, password);
		// If successful.
		if (ftp != null)
		{
			try
			{
				// delete file
				result = ftp.deleteFile(filename);
			} 
			catch (IOException e)
			{
                e.printStackTrace();
			}
			finally
			{
				if (ftp.isConnected())
				{
					try
					{
		    			ftp.logout();
						ftp.disconnect();
					} 
					catch (IOException ioe){}
				}
				ftp = null;
			}
		}
		return result;
	}
}
