package modreg;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.ByteBuffer;

import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;

import modbus.mod;

public class modreg extends JApplet
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * GUI Components
	 */
	private ButtonGroup       BngEndian        = new ButtonGroup();
	private ButtonGroup       BngDataType      = new ButtonGroup();
	private ButtonGroup       BngRegType       = new ButtonGroup();
	private JSeparator        SepVert;
	private JPanel            panel;
	private JLabel            valueFormatLabel;
	private JRadioButton      RbnBE;
	private JRadioButton      RbnLE;
	private JRadioButton      RbnFloat;
	private JRadioButton      RbnInteger;
	private JRadioButton      rbn4x;
	private JRadioButton      rbn3x;
	private JRadioButton      rbn0x;
	private JLabel            statusLabel;
	private JLabel            valueLabel;
	private JLabel            LblRegister;
	private JLabel            LblAddress;
	private JButton           BnWrite;
	private JButton           BnRead;
	private JTextField        EbStatus;
	private JTextField        EbValue;
	private JTextField        EbRegister;
	private JTextField        EbAddress;
    private JTextField EbIP;
    private JLabel LblIP;
    
    private final JLabel        Lbl32BitFormat = new JLabel();
    private final JLabel        Lbl32BitEndian = new JLabel();
    private final JRadioButton  rbn1x = new JRadioButton();

	/**
	 * Constants.
	 */
	public final static int   MODE_COIL        = 0;
	public final static int   MODE_16          = 1;
	public final static int   MODE_32          = 2;
	public final static int   MODE_FLOAT       = 3;
	public final static int   MODE_STRING      = 4;
	
	/**
     * Data members.
     */
    // Set by Connect(); used when changing connection with host.
    private String				hostAddress;
    
    static boolean            	dbug_on            = false;
    static String             	dbug_ip            = "10.0.0.240";
    static int                	dbug_unit          = 1;
    //
    private boolean            	applet_running       = true;
    private boolean            	connect_task_running = false;
    //
    private mod.device         	comBas               = new mod.device();

    private ConnectTask        	connect_task         = new ConnectTask();
    private JCheckBox ckb32bit;

	/**
	 * Create the applet
	 */
	public modreg()
	{
		super();
		initComponents();
		// Further initialization.
		myInit();
	}

	public void init()
	{
		// Get code base string.
		hostAddress = this.getCodeBase().toString().toLowerCase();
		// If forcing the address.
		if (dbug_on == true)
			hostAddress = dbug_ip;
		// Else if executing from local machine.
		else if (hostAddress.startsWith("file"))
			hostAddress = "localhost";
		// Else for real.
		else
		{
			hostAddress = hostAddress.replace("http://", " ");
			hostAddress = hostAddress.replace("/", " ").trim();
		}
		// Connect with host; start background thread.
		Connect(hostAddress , true);
	}

	@Override
	public void destroy()
	{
        //applet_running = false;
        //comBas.Disconnect();
		Disconnect();
	}

    boolean validateIPAddress( String ip, byte[] ip_byte)
    {
        int k;
        String[] temp = null;

        // Do the split.
        temp = ip.split("\\.");

        // should have 4 values
        if (temp.length < 4)
            return false;

        // no whitespace allowed
        for (k = 0; k < 4; k++)
        {
            if (temp[k].length() != temp[k].trim().length())
                return false;
        }

        if ((temp[0].length() == 0) || (temp[1].length() == 0) || (temp[2].length() == 0) || (temp[3].length() == 0))
            return false;

        // valid range is 0 to 255
        for (k = 0; k < 4; k++)
        {
            if ((Integer.valueOf(temp[k]).intValue() < 0) || (Integer.valueOf(temp[k]).intValue() > 255))
                return false;
            ip_byte[k] = (byte)Integer.valueOf(temp[k]).intValue();
        }

        return true;
    }
    
    /**
     * This thread operates in the background to try and re-establish the link
     * with the host should it be broken.
     * 
     * @author rcw
     * 
     */
    public class ConnectTask extends SwingWorker<Void, Void>
    {
        @Override
        public Void doInBackground()
        {
            while (applet_running)
            {
                if (!comBas.IsConnected())
                {
                	
                    comBas.Connect(hostAddress, mod.def.PORT_TCP, mod.def.PROT_TCP);
                    if ( comBas.IsConnected())
                    {
                        EbAddress.setEditable(true);
                        EbRegister.setEditable(true);
                        EbValue.setEditable(true);
                        BnRead.setEnabled(true);
                        BnWrite.setEnabled(true);
                        EbIP.setEditable(true);
                    }
                    
                }
                try
                {
                    Thread.sleep(2000);
                } catch (InterruptedException e){}
            }
            return null;
        }
    }

	/**
	 * Returns true if connected to host.
	 * 
	 * @return = comBas.m_connected.
	 */
	public boolean IsConnected()
	{
		return comBas.IsConnected();
	}

	public void Disconnect()
	{
		comBas.Disconnect();
		EbAddress.setEditable(false);
		EbRegister.setEditable(false);
		EbValue.setEditable(false);
        BnRead.setEnabled(false);
        BnWrite.setEnabled(false);
        EbIP.setEditable(false);
	}

	/**
	 * Connects with 'hostAddress'.
	 * 
	 * @param address = Dotted string address.
	 */
	public void Connect(String address , boolean start_connect_task)
	{
		hostAddress = address;
		comBas.Connect(hostAddress, mod.def.PORT_TCP , mod.def.PROT_TCP);
		if (comBas.IsConnected())
		{
			EbIP.setEditable(true);
			EbAddress.setEditable(true);
			EbRegister.setEditable(true);
			EbValue.setEditable(true);
            BnRead.setEnabled(true);
            BnWrite.setEnabled(true);
		}
		else
		{
			EbStatus.setText("Cannot connect to target");
		}
		if (start_connect_task && !connect_task_running)
		{
		    connect_task.execute();
		    connect_task_running = true;
		}
	}

	private void Show32(boolean _32Bit)
	{
	    if (_32Bit)
	    {
            RbnInteger.setEnabled(true);
            RbnFloat.setEnabled(true);
            RbnLE.setEnabled(true);
            RbnBE.setEnabled(true);
	    }
	    else
	    {
            RbnInteger.setEnabled(false);
            RbnFloat.setEnabled(false);
            RbnLE.setEnabled(false);
            RbnBE.setEnabled(false);
	    }
	}
	
	private void UpdateRbn()
	{
		boolean		enable32 = false;
	    boolean		writeEnable = true;
	    String		regLabel = "Register Number";
	    
	    if (rbn0x.isSelected())
	    {
	        regLabel = "Coil Number";
	    }
	    else if (rbn1x.isSelected())
	    {
	        writeEnable = false;
	        regLabel = "Input Number";
	    }
	    else if (rbn3x.isSelected())
	    {
	        writeEnable = false;
	        enable32 = true;
	    }
	    else if (rbn4x.isSelected())
	    {
	        enable32 = true;
	    }
	    
	    ckb32bit.setEnabled(enable32);
	    Show32(ckb32bit.isSelected());
	    
        BnWrite.setEnabled(writeEnable); 
        
        LblRegister.setText(regLabel);

		// Update.
		validate();
		repaint();
	}

	private void ErrorMessage( String text )
	{
	    mod.err    e = mod.err.getObj(text);

	    switch (e)
		{
			case ILLEGAL_DATA_ADDRESS:
			case ILLEGAL_FUNCTION:
			case ILLEGAL_DATA_VALUE:
			case ILLEGAL_OBJECT_INSTANCE:
				EbStatus.setText(e.getText());
				break;
			default:
				EbStatus.setText(text);
				if (connect_task_running)
				{
					Disconnect();
				}
				break;
		}
	}

	private void ReadVal()
	{
		int tmp;
		mod.regOp32 rp = new mod.regOp32();
		int slv = Integer.decode(EbAddress.getText());
		int reg = Integer.decode(EbRegister.getText());
		String	ipAddr = EbIP.getText();
		byte[]	ip_addr = {0, 0, 0, 0};
		
        if(validateIPAddress(ipAddr, ip_addr) == false)
		{
        	ErrorMessage("Invalid IP address");
        	return;
		}

        // Return failure if not already connected.
        if (comBas.IsConnected() == false)
        {
            return;
        }
		
		if (rbn0x.isSelected())
		{
		    try
		    {
		    	if(ipAddr.equals("0.0.0.0"))
		    		EbValue.setText(Integer.toString(comBas.ReadCoil(slv, reg)));
		    	else
		    		EbValue.setText(Integer.toString(comBas.ReadCoilMTCP(slv, reg, ip_addr)));
		    		
				EbStatus.setText("SUCCESS");
			}
			catch (IOException e)
			{
                ErrorMessage(e.getMessage());
			}
		}
		else if (rbn1x.isSelected())
		{
            try
            {
		    	if(ipAddr.equals("0.0.0.0"))
		    		EbValue.setText(Integer.toString(comBas.ReadInp(slv, reg)));
		    	else
		    		EbValue.setText(Integer.toString(comBas.ReadInpMTCP(slv, reg, ip_addr)));
		    		
                EbStatus.setText("SUCCESS");
            }
            catch (IOException e)
            {
                ErrorMessage(e.getMessage());
            }
		}
		else if (rbn3x.isSelected() || rbn4x.isSelected())
		{
			if (ckb32bit.isSelected())
			{
				rp.float_op = RbnFloat.isSelected();
				rp.big_endian = RbnBE.isSelected();
				try
				{
					if(rbn4x.isSelected())
					{
				    	if(ipAddr.equals("0.0.0.0"))
				    		comBas.ReadRegPair(slv, reg, rp);
				    	else
				    		comBas.ReadRegPairMTCP(slv, reg, ip_addr, rp);
					}
					else
					{
				    	if(ipAddr.equals("0.0.0.0"))
				    		comBas.ReadRegInpPair(slv, reg, rp);
				    	else
				    		comBas.ReadRegInpPairMTCP(slv, reg, ip_addr, rp);
					}
						
	                if (RbnFloat.isSelected())
	                    EbValue.setText(Float.toString(rp.f));
	                else
	                    EbValue.setText(Integer.toString(rp.i));
	                EbStatus.setText("SUCCESS");
				}
	            catch (IOException e)
	            {
	                ErrorMessage(e.getMessage());
	            }
			}
			else	// 16 bit.
			{
	            try
	            {
	            	if(rbn4x.isSelected())
	            	{
				    	if(ipAddr.equals("0.0.0.0"))
				    		tmp= comBas.ReadReg16(slv, reg); 
				    	else
				    		tmp= comBas.ReadReg16MTCP(slv, reg, ip_addr); 
				    	
	            		EbValue.setText(Integer.toString(tmp));
	            	}
	            	else
	            	{
				    	if(ipAddr.equals("0.0.0.0"))
				    		tmp= comBas.ReadRegInp16(slv, reg); 
				    	else
				    		tmp= comBas.ReadRegInp16MTCP(slv, reg, ip_addr); 				    		
	            		EbValue.setText(Integer.toString(tmp));	            		
	            	}
					EbStatus.setText("SUCCESS");
				}
	            catch (IOException e)
	            {
	                ErrorMessage(e.getMessage());
	            }
			}
		}
		else		// Scaled value.
		{
            try
            {
				EbValue.setText(comBas.ReadRegStr(slv, reg));
				EbStatus.setText("SUCCESS");
			}
            catch (IOException e)
            {
                ErrorMessage(e.getMessage());
            }
		}
	}
	/**
	 * Parses 'val' into strings separated by commas, converts the
	 * strings to integers, and places the integers into writeVal[].
	 * 
	 * @param val = comma separated integer values.
	 * @return = number of strings parsed.
	 */
	private int[] ParseVal( String val )
	{
		int			i , strCnt , tmpVal , int_val[];
		int[][]		strIdx = new int[32][2];
		int			val_len = val.length();
		ByteBuffer	bbuf = ByteBuffer.wrap(val.getBytes());

		// Return if no values.
		if ( val_len == 0 )
			return null;
		// Count the number of values, and setup index values
		// for start and end of each string. Assume one string
		// with one value.
		// NOTE: The second parameter to substring() (used below) is the end character + 1,
		// so we must set the second index to one character past the end of the string.
		strCnt = 0;
		strIdx[0][0] = 0;
		// For each character in the string.
		for ( i = 0 ; i < val_len ; ++i )
		{
			// If delimiter found.
			if ( bbuf.get() == ',' )
			{
				// Mark the end of the string (+1).
				strIdx[strCnt][1] = i;
				// Increment number of strings; check for overflow.
				++strCnt;
				if ( strCnt >= strIdx.length )
					return null;
				// Set index markers to start of next string.
				strIdx[strCnt][0] = strIdx[strCnt][1] = i + 1;
			}
		}
		// Last index is always end of string.
		strIdx[strCnt][1] = val_len;
		// Always have one string.
		++strCnt;
		// Allocate storage for values.
		int_val = new int[strCnt];
		// Create integers from strings and put into array.
		for ( i = 0 ; i < strCnt ; ++i )
		{
			try
			{
				tmpVal = Integer.decode(val.substring(strIdx[i][0] , strIdx[i][1]));
			}
			catch (NumberFormatException e)
			{
				return null;
			}
			int_val[i] = tmpVal;
		}
		// And return.
		return int_val;
	}
	
	private void WriteVal()
	{
		int val;
		int   write_val[];
		mod.regOp32 rp = new mod.regOp32();
		int slv = Integer.decode(EbAddress.getText());
		int reg = Integer.decode(EbRegister.getText());
		String	ipAddr = EbIP.getText();
		byte[]	ip_addr = {0, 0, 0, 0};
		
        if(validateIPAddress(ipAddr, ip_addr) == false)
		{
        	ErrorMessage("Invalid IP address");
        	return;
		}
        
        // Return failure if not already connected.
        if (comBas.IsConnected() == false)
        {
            return;
        }
		if (rbn0x.isSelected())
		{
			val = Integer.decode(EbValue.getText());
			try
			{
		    	if(ipAddr.equals("0.0.0.0"))
		    		comBas.WriteCoil(slv, reg, val);
		    	else
		    		comBas.WriteCoilMTCP(slv, reg, ip_addr, val);
		    		
                EbStatus.setText("SUCCESS");
			}
            catch (IOException e)
            {
                ErrorMessage(e.getMessage());
            }
		}
		else if (rbn4x.isSelected())
		{
			if (ckb32bit.isSelected())
			{
				rp.float_op = RbnFloat.isSelected();
				rp.big_endian = RbnBE.isSelected();
				if (rp.float_op)
					rp.f = Float.parseFloat(EbValue.getText());
				else
					rp.i = Integer.parseInt(EbValue.getText());
				try
				{
			    	if(ipAddr.equals("0.0.0.0"))
			    		comBas.WriteRegPair(slv, reg, rp);
			    	else
			    		comBas.WriteRegPairMTCP(slv, reg, ip_addr, rp);
			    		
	                EbStatus.setText("SUCCESS");
				}
				catch (IOException e)
				{
	                ErrorMessage(e.getMessage());
				}
			}
			else	// 16 bit.
			{
				write_val = ParseVal(EbValue.getText());
				if ( write_val != null )
				{
				    try
				    {
				    	if(ipAddr.equals("0.0.0.0"))
				    		comBas.WriteReg16(slv, reg, write_val , write_val.length );
				    	else
				    		comBas.WriteReg16MTCP(slv, reg, ip_addr, write_val , write_val.length );
		                EbStatus.setText("SUCCESS");
				    }
				    catch (IOException e)
		            {
		                ErrorMessage(e.getMessage());
		            }
				}
				else
				{
					EbStatus.setText("ERROR: Bad number format");
				}
			}
		}
	}
	
	private void myInit()
	{
        // Further initialization.
        RbnInteger.setEnabled(false);
        RbnFloat.setEnabled(false);
        RbnLE.setEnabled(false);
        RbnBE.setEnabled(false);
        BnRead.setEnabled(false);
        BnWrite.setEnabled(false);
	}

	private void initComponents()
	{
		setLayout(null);

		EbAddress = new JTextField();
		EbAddress.setEditable(false);
		EbAddress.setText("1");
		EbAddress.setBounds(10, 128, 125, 25);
		getContentPane().add(EbAddress);

		EbRegister = new JTextField();
		EbRegister.setEditable(false);
		EbRegister.setText("1");
		EbRegister.setBounds(10, 179, 125, 25);
		getContentPane().add(EbRegister);

		EbValue = new JTextField();
		EbValue.setEditable(false);
		EbValue.setBounds(10, 230, 125, 25);
		getContentPane().add(EbValue);

		EbStatus = new JTextField();
		EbStatus.setBounds(10, 298, 440, 25);
		getContentPane().add(EbStatus);

		BnRead = new JButton();
		BnRead.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				ReadVal();
			}
		});
		BnRead.setFont(new Font("Sans", Font.PLAIN, 12));
		BnRead.setText("READ");
		BnRead.setBounds(151, 261, 122, 25);
		getContentPane().add(BnRead);

		BnWrite = new JButton();
		BnWrite.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				WriteVal();
			}
		});
		BnWrite.setFont(new Font("Sans", Font.PLAIN, 12));
		BnWrite.setText("WRITE");
		BnWrite.setBounds(329, 261, 122, 25);
		getContentPane().add(BnWrite);

		LblAddress = new JLabel();
		LblAddress.setFont(new Font("Sans", Font.PLAIN, 12));
		LblAddress.setText("Slave Address");
		LblAddress.setBounds(10, 108, 122, 14);
		getContentPane().add(LblAddress);

		LblRegister = new JLabel();
		LblRegister.setFont(new Font("Sans", Font.PLAIN, 12));
		LblRegister.setText("Register Number");
		LblRegister.setBounds(10, 159, 125, 14);
		getContentPane().add(LblRegister);

		valueLabel = new JLabel();
		valueLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		valueLabel.setText("Value");
		valueLabel.setBounds(10, 210, 77, 14);
		getContentPane().add(valueLabel);

		statusLabel = new JLabel();
		statusLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		statusLabel.setText("Status");
		statusLabel.setBounds(10, 278, 77, 14);
		getContentPane().add(statusLabel);

		valueFormatLabel = new JLabel();
		valueFormatLabel.setHorizontalAlignment(SwingConstants.CENTER);
		valueFormatLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
		valueFormatLabel.setText("Value Format");
		valueFormatLabel.setBounds(151, 28, 261, 14);
		getContentPane().add(valueFormatLabel);

		panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED));
		panel.setBounds(151, 48, 300, 207);
		getContentPane().add(panel);

		RbnInteger = new JRadioButton();
		RbnInteger.setSelected(true);
		BngDataType.add(RbnInteger);
		RbnInteger.setBounds(188, 37, 104, 22);
		panel.add(RbnInteger);
		RbnInteger.setFont(new Font("Sans", Font.PLAIN, 12));
		RbnInteger.setText("Integer");

		RbnFloat = new JRadioButton();
		BngDataType.add(RbnFloat);
		RbnFloat.setBounds(188, 72, 104, 22);
		panel.add(RbnFloat);
		RbnFloat.setFont(new Font("Sans", Font.PLAIN, 12));
		RbnFloat.setText("Float");

		RbnLE = new JRadioButton();
		RbnLE.setSelected(true);
		BngEndian.add(RbnLE);
		RbnLE.setBounds(188, 134, 104, 22);
		panel.add(RbnLE);
		RbnLE.setFont(new Font("Sans", Font.PLAIN, 12));
		RbnLE.setText("LOW : HIGH");

		RbnBE = new JRadioButton();
		BngEndian.add(RbnBE);
		RbnBE.setBounds(188, 169, 104, 22);
		panel.add(RbnBE);
		RbnBE.setFont(new Font("Sans", Font.PLAIN, 12));
		RbnBE.setText("HIGH : LOW");

		rbn0x = new JRadioButton();
		rbn0x.setToolTipText("Modbus 0x Coil (Read-Write)");
		rbn0x.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(final MouseEvent e)
			{
				UpdateRbn();
			}
		});
		BngRegType.add(rbn0x);
		rbn0x.setBounds(10, 10, 140, 22);
		panel.add(rbn0x);
		rbn0x.setFont(new Font("Sans", Font.PLAIN, 12));
		rbn0x.setText("0X:Coil");

		rbn3x = new JRadioButton();
		rbn3x.setToolTipText("Modbus 3x Input Register(s) (Read-Only)");
		rbn3x.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(final MouseEvent e)
			{
				UpdateRbn();
			}
		});
		BngRegType.add(rbn3x);
		rbn3x.setBounds(10, 75, 140, 22);
		panel.add(rbn3x);
		rbn3x.setFont(new Font("Sans", Font.PLAIN, 12));
		rbn3x.setText("3X:Input Reg");

		rbn4x = new JRadioButton();
		rbn4x.setSelected(true);
		rbn4x.setToolTipText("Modbus 4x Holding Register(s) (Read-Write)");
		BngRegType.add(rbn4x);
		rbn4x.addMouseListener(new MouseAdapter()
		{
			public void mouseClicked(final MouseEvent e)
			{
				UpdateRbn();
			}
		});
		rbn4x.setBounds(10, 106, 140, 22);
		panel.add(rbn4x);
		rbn4x.setFont(new Font("Sans", Font.PLAIN, 12));
		rbn4x.setText("4X:Holding Reg");

		SepVert = new JSeparator();
		SepVert.setOrientation(SwingConstants.VERTICAL);
		SepVert.setBounds(159, 0, 11, 207);
		panel.add(SepVert);
			
		panel.add(Lbl32BitFormat);
		Lbl32BitFormat.setFont(new Font("Dialog", Font.PLAIN, 12));
		Lbl32BitFormat.setText("32-Bit Format");
		Lbl32BitFormat.setBounds(188, 10, 104, 14);
			
		panel.add(Lbl32BitEndian);
		Lbl32BitEndian.setFont(new Font("Dialog", Font.PLAIN, 12));
		Lbl32BitEndian.setText("32-Bit Endian");
		Lbl32BitEndian.setBounds(188, 107, 104, 14);
			
		panel.add(rbn1x);
		rbn1x.setToolTipText("Modbus 1x Input (Read-Only)");
		rbn1x.addMouseListener(new MouseAdapter() 
		{
			public void mouseClicked(final MouseEvent e)
			{
	             UpdateRbn();
			}
		});
		BngRegType.add(rbn1x);
		rbn1x.setFont(new Font("Dialog", Font.PLAIN, 12));
		rbn1x.setText("1X:Discrete Input");
		rbn1x.setBounds(10, 40, 140, 22);
			
		ckb32bit = new JCheckBox("32-bit");
		ckb32bit.setToolTipText("Two Modbus Registers used as one value");
		ckb32bit.addMouseListener(new MouseAdapter()
		{
			@Override
			public void mouseClicked( MouseEvent arg0 )
			{
				if (ckb32bit.isSelected())
					Show32(true);
				else
					Show32(false);
			}
		});
		ckb32bit.setFont(new Font("Dialog", Font.PLAIN, 12));
		ckb32bit.setBounds(10, 137, 140, 23);
		panel.add(ckb32bit);
	    LblIP = new JLabel();
	    LblIP.setFont(new Font("Dialog", Font.PLAIN, 12));
	    LblIP.setText("IP Address");
	    LblIP.setBounds(10, 48, 122, 14);
	    getContentPane().add(LblIP);

	    EbIP = new JTextField();
	    EbIP.setText("0.0.0.0");
	    EbIP.setEditable(false);
	    EbIP.setBounds(10, 68, 125, 25);
	    getContentPane().add(EbIP);
	}
}
