package MappingCfg;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

import modbus.mod;

import bas_remote.bas_def;

public class devProfilePanel extends JPanel
{
	mod.device     				comBas             	= new mod.device();
    private DefaultListModel  	listModel;
	private JList 				templateList;
	private JLabel 				errorLabel;
	String	password			= "ccsi2431";
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public devProfilePanel() 
	{
		super();
		setFocusable(false);
		setLayout(null);
		setBounds(10, 10, 418, 475);

		final JLabel deviceProfileLabel = new JLabel();
		deviceProfileLabel.setFont(new Font("Sans", Font.BOLD, 20));
		deviceProfileLabel.setForeground(Color.RED);
		deviceProfileLabel.setText("Device Profile");
		deviceProfileLabel.setBounds(21, 10, 172, 35);
		add(deviceProfileLabel);

		listModel = new DefaultListModel();
		templateList = new JList(listModel);
		templateList.setFont(new Font("Courier", Font.BOLD, 12));
		templateList.setDropMode(DropMode.USE_SELECTION);
		templateList.setBorder(new BevelBorder(BevelBorder.LOWERED));
		templateList.setBounds(11, 46, 383, 297);
		add(templateList);
        // Clear the box.
		templateList.removeAll();
        // Loop to get all object instances.
        for (int i = 0; i < fileFunction.template_qty; ++i)
        {
        	// Add object to list.
        	listModel.addElement(fileFunction.template_filename[i]);
        }
        templateList.setSelectedIndex(-1);

		final JButton deleteButton = new JButton();
		deleteButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				String	filename			= "/data/template/";
				int		i;
				
				int	index = templateList.getSelectedIndex();
				String	ip = null;
				
				errorLabel.setText("");
				if(index < 0)
				{
					errorLabel.setText("Error: must select a device to delete");
					return;
				}
		    	try 
		    	{
					ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
				} 
		    	catch (IOException e) 
		    	{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
		    	if(ip == null)
		    		return;
		    	
				filename = filename.concat(fileFunction.template_filename[index]);
				if(filename == null)
					return;
				if(fileFunction.delFile(ip, "root", password, filename) == true)
				{
					if(fileFunction.template_qty > 0)
					{
						for(i = index; i < (fileFunction.template_qty - 1); i++)
						{
							fileFunction.template_filename[i] = fileFunction.template_filename[i + 1];
						}
						fileFunction.template_qty--;
					}
					listModel.remove(index);
			    	errorLabel.setText("Delete file successfully");
				}
			    else
			    	errorLabel.setText("Error: can't delete selected device");
			}
		});
		deleteButton.setText("Delete");
		deleteButton.setBounds(61, 383, 91, 24);
		add(deleteButton);

		final JButton backButton = new JButton();
		backButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				cmuFlag.set_exit_profile_panel();
			}
		});
		backButton.setText("Back");
		backButton.setBounds(235, 383, 78, 24);
		add(backButton);

		errorLabel = new JLabel();
		errorLabel.setBounds(11, 350, 345, 24);
		add(errorLabel);
	}

}
