/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package bacnet;

/**
 *
 * @author rcw
 */
public class bac_def
{
    //
    //----------------------------------------------------------------------
    //
    // Numeric values for BACnet properties supported by ReadObj()
    // and WriteObj().
    //
    public final static int COV_INCREMENT       = 22;
    public final static int DESCRIPTION         = 28;
    public final static int HIGH_LIMIT          = 45;
    public final static int LOW_LIMIT           = 59;
    public final static int MAX_PRES_VALUE      = 65;
    public final static int MIN_PRES_VALUE      = 69;
    public final static int OBJECT_IDENTIFIER   = 75;
    public final static int OBJECT_NAME         = 77;
    public final static int OBJECT_TYPE         = 79;
    public final static int OUT_OF_SERVICE      = 81;
    public final static int PRESENT_VALUE       = 85;
    public final static int RELIABILITY         = 103;
    public final static int RELINQUISH_DEFAULT  = 104;
    public final static int STATUS_FLAGS        = 111;
    public final static int UNITSX              = 117;
    public final static int BAC_OBJ_QTY         = 0x0ff00;
    public final static int BAC_SYS_NAME        = 0x0ff01;
    public final static int BAC_DEV_INSTANCE    = 0x0ff02;
    public final static int BAC_UDP_PORT        = 0x0ff03;
    public final static int BAC_BBMD_IP         = 0x0ff04;
    public final static int BAC_TTL             = 0x0ff05;
    public final static int BAC_OBJ_INDEX       = 0x0ff06;
    public final static int BAC_MOD_DEV_FILENAME= 0x0ff07;
    public final static int BAC_MOD_DEV_INSTANCE= 0x0ff07;
    //
    //----------------------------------------------------------------------
    //
    // Numeric values for various units.
    // This is a limited number that is used for BAS I/O types.
    //
    public final static int	ANALOG_INPUT		= 0;
    public final static int	ANALOG_OUTPUT		= 1;
    public final static int	ANALOG_VALUE		= 2;
    public final static int	BINARY_INPUT		= 3;
    public final static int	BINARY_OUTPUT		= 4;
    public final static int	BINARY_VALUE		= 5;
    //
    //----------------------------------------------------------------------
    //
    // BACnet object types.
    //
    public final static String		obj_type[] =
    {
	"ANALOG INPUT",			// 0
	"ANALOG OUTPUT",		// 1
	"ANALOG VALUE",			// 2
	"BINARY INPUT",			// 3
	"BINARY OUTPUT",		// 4
	"BINARY VALUE",			// 5
	"CALENDAR",			// 6
	"COMMAND",			// 7
	"DEVICE",			// 8
	"EVENT ENROLLMENT",		// 9
	"FILE 0",			// 10
	"GROUP",			// 11
	"LOOP",				// 12
	"MULTI STATE INPUT",		// 13
	"MULTI STATE OUTPUT",		// 14
	"NOTIFICATION CLASS",		// 15
	"PROGRAM",			// 16
	"SCHEDULE",			// 17
    };
    //
    //----------------------------------------------------------------------
    //
    // This array of n x 2 integers gives the starting
    // index of unit[], and the number of unit[] values
    // are included in the unit class.
    // unit_desc[n][0] = starting index in unit[] for unit_class[n].
    // unit_desc[n][1] = number of unit[] values.
    //
    public final static int		unit_desc[][] =
    {
	{  0 ,  2 },
	{  2 , 14 },
	{ 16 ,  7 },
	{ 23 ,  2 },
	{ 25 ,  3 },
	{ 28 ,  2 },
	{ 30 ,  4 },
	{ 34 ,  5 },
	{ 39 ,  3 },
	{ 42 ,  5 },
	{ 47 ,  6 },
	{ 53 ,  9 },
	{ 62 ,  5 },
	{ 67 ,  7 },
	{ 74 ,  5 },
	{ 79 ,  5 },
	{ 84 ,  6 },
	{ 90 , 15 },
    };
    //
    //----------------------------------------------------------------------
    //
    // This array of strings describes the unit groups; area, electrical, etc.
    // There are multiple unit types defined for each unit group.
    //
    public final static String		unit_group[] =
    {
	"Area",
	"Electrical",
	"Energy",
	"Enthalpy",
	"Frequency",
	"Humidity",
	"Length",
	"Light",
	"Mass",
	"Mass Flow",
	"Power",
	"Pressure",
	"Temperature",
	"Time",
	"Velocity",
	"Volume",
	"Volumetric Flow",
	"Others",
    };
    //
    //----------------------------------------------------------------------
    //
    // Numeric values for various units.
    // This is a limited number that is used for BAS I/O types.
    //
    public final static int	MILLIAMPERES		= 2;
    public final static int	AMPERES			= 3;
    public final static int	VOLTS			= 5;
    public final static int	DEGREES_CELCIUS		= 62;
    public final static int	DEGREES_FARENHEIT	= 64;
    public final static int	NO_UNITS		= 95;
    
    //
    //----------------------------------------------------------------------
    //
    // This array of strings describes the BACnet units.
    //
    public final static String		unit[] =
    {
    //Area   
	"SQUARE_METERS",                       // 0
	"SQUARE_FEET",                         // 1
    //Electrical
	"MILLIAMPERES",                        // 2
	"AMPERES",                             // 3
	"OHMS",                                // 4
	"VOLTS",                               // 5
	"KILOVOLTS",                           // 6
	"MEGAVOLTS",                           // 7
	"VOLT_AMPERES",                        // 8
	"KILOVOLT_AMPERES",                    // 9
	"MEGAVOLT_AMPERES",                    //10
	"VOLT_AMPERES_REACTIVE",               //11
	"KILOVOLT_AMPERES_REACTIVE",           //12
	"MEGAVOLT_AMPERES_REACTIVE",           //13
	"DEGREES_PHASE",                       //14
    	"POWER_FACTOR",                        //15
    //Energy
	"JOULES",                              //16
	"KILOJOULES",                          //17
	"WATT_HOURS",                          //18
	"KILOWATT_HOURS",                      //19
	"BTU",                                 //20
	"THERM",                               //21
	"TON_HOR",                             //22
    //Enthalpy
	"JOULES_PER_KILOGRAM_DRY_AIR",         //23
	"BTU_PER_POUND_DRY_AIR",               //24
    //Frecuency
	"CYCLES_PER_HOUR",                     //25
	"CYCLES_PER_MINUTE",                   //26
	"HERTZ",                               //27
    //Humidity
	"GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR",	//28
	"PERCENT_RELATIVE_HUMIDITY",           //29
    //Length
	"MILLIMETER",                          //30
	"METERS",                              //31
	"INCH",                                //32
	"FEET",                                //33
    //Light
	"WATTS_PER_SQUARE_FOOT",               //34
	"WATTS_PER_SQUARE_METER",              //35
	"LUMEN",                               //36
	"LUX",                                 //37
	"FOOT_CANDLES",                        //38
    //Mass
	"KILOGRAMS",                           //39
	"POUNDS_MASS",                         //40
	"TONS",                                //41
    //Mass Flow
	"KILOGRAMS_PER_SECOND",                //42
	"KILOGRAMS_PER_MINUTE",                //43
	"KILOGRAMS_PER_HOUR",                  //44
	"POUNDS_MASS_PER_MINUTE",              //45
	"POUNDS_MASS_PER_HOUR",                //46
    //Power
	"WATTS",                               //47
	"KILOWATTS",                           //48
	"MEGAWATTS",                           //49
	"BTU_PER_HOUR",                        //50
	"HORSEPOWER",                          //51
	"TONS_REFRIGERATIONS",                 //52
    //Pressure
	"PASCALS",                              //53
	"KILOPASCAL",                          //54
	"BAR",                                 //55
	"POUNDS_FORCE_PER_SQUARE_INCH",        //56
	"CENTIMETERS_OF_WATER",                //57
	"INCHES_OF_WATER",                     //58
	"MILLIMETERS_OF_MERCURY",              //59
	"CENTIMETERS_OF_MERCURY",              //60
	"INCHES_OF_MERCURY",                   //61
    //Temperature
	"DEGREES_CELSIUS",                     //62
	"DEGREES_KELVIN",                      //63
	"DEGREES_FAHRENHEIT",                  //64
	"DEGREE_DAYS_CELSIUS",                 //65
	"DEGREE_DAYS_FAHRENHEIT",              //66
    //Time
	"YEAR",                                //67
	"MONTH",                               //68
	"WEEK",                                //69
	"DAY",                                 //70
	"HOUR",                                //71
	"MINUTE",                              //72
	"SECOND",                              //73
    //Velocity
	"METERS_PER_SECOND",                   //74
	"KILOMETERS_PER_HOUR",                 //75
	"FEET_PER_SECOND",                     //76
	"FEET_PER_MINUTE",                     //77
	"MILES_PER_HOUR",                      //78
    //Volume
	"CUBIC_FEET",                          //79
	"CUBIC_METERS",                        //80
	"IMPERIAL_GALLONS",                    //81
	"LITERS",                              //82
	"US_GALLONS",                          //83
    //Volumetric Flow
	"CUBIC_FEET_PER_MINUTE",               //84
	"CUBIC_METERS_PER_SECOND",             //85
	"IMPERIAL_GALLONS_PER_MINUTE",         //86
	"LITERS_PER_SECOND",                   //87
	"LITERS_PER_MINUTE",                   //88
	"US_GALLONS_PER_MINUTE",               //89
    //Others
	"DEGREES_ANGULAR",                     // 90
	"DEGREES_CELSIUS_PER_HOUR",            // 91
	"DEGREES_CELSIUS_PER_MINUTE",          // 92
	"DEGREES_FAHRENHEIT_PER_HOUR",         // 93
	"DEGREES_FAHRENHEIT_PER_MINUTE",       // 94
	"NO_UNITS",                            // 95
	"PARTS_PER_MILLION",                   // 96
	"PARTS_PER_BILLION",                   // 97
	"PERCENT",                             // 98
	"PERCENT_PER_SECOND",                  // 99
	"PER_MINUTE",                          //100
	"PER_SECOND",                          //101
	"PSI_PER_DEGREE_FAHRENHEIT",           //102
	"RADIANS",                             //103
	"REVOLUTIONS_PER_MINUTE",               //104
    };
    //
    //----------------------------------------------------------------------
    //
    // This array of strings describes the BACnet units.
    //
    public final static String		unitStr[] =
    {
    //Area   
	"SqM",					// 0
	"SqFt",					// 1
    //Electrical
	"mA",					// 2
	"A",					// 3
	"Ohms",					// 4
	"V",					// 5
	"KV",					// 6
	"MV",					// 7
	"VA",					// 8
	"KVA",					// 9
	"MVA",                    		//10
	"VAR",					//11
	"KVAR",					//12
	"MVAR",					//13
	"Deg Ph",				//14
    	"PF",					//15
    //Energy
	"J",					//16
	"KJ",					//17
	"WH",					//18
	"KWH",					//19
	"BTU",					//20
	"THERM",				//21
	"T_HOR",				//22
    //Enthalpy
	"J/KgDA",				//23
	"BTU/LbDA",				//24
    //Frecuency
	"CPH",					//25
	"CPM",					//26
	"Hz",					//27
    //Humidity
	"gW/KgDA",				//28
	"%RH",					//29
    //Length
	"mm",					//30
	"m",					//31
	"in",					//32
	"ft",					//33
    //Light
	"W/SqF",				//34
	"W/SqM",				//35
	"LUMEN",				//36
	"LUX",					//37
	"FtCdl",				//38
    //Mass
	"Kg",					//39
	"Lbm",					//40
	"TONS",					//41
    //Mass Flow
	"Kg/sec",				//42
	"Kg/min",				//43
	"Kg/hr",				//44
	"Lbm/min",				//45
	"Lbm/hr",				//46
    //Power
	"W",					//47
	"KW",					//48
	"MW",					//49
	"BTU/hr",				//50
	"HP",					//51
	"Tons R",				//52
    //Pressure
	"Ps",					//53
	"KPs",					//54
	"BAR",					//55
	"Lb/SqIn",				//56
	"cmH2O",				//57
	"inH2O",				//58
	"mmHg",					//59
	"cmHg",					//60
	"inHg",					//61
    //Temperature
	"DegC",					//62
	"DegK",					//63
	"DegF",					//64
	"DegDC",				//65
	"DegDF",				//66
    //Time
	"yr",					//67
	"mo",					//68
	"wk",					//69
	"d",					//70
	"hr",					//71
	"min",					//72
	"sec",					//73
    //Velocity
	"M/sec",				//74
	"KM/hr",				//75
	"Ft/sec",				//76
	"Ft/min",				//77
	"MPH",					//78
    //Volume
	"CuFt",					//79
	"CuM",					//80
	"IMGal",				//81
	"L",					//82
	"USGal",				//83
    //Volumetric Flow
	"CuFt/min",				//84
	"CuM/sec",				//85
	"IMGal/min",				//86
	"L/sec",				//87
	"L/min",				//88
	"USGal/min",				//89
    //Others
	"Deg",					// 90
	"DegC/hr",				// 91
	"DegC/min",				// 92
	"DegF/hr",				// 93
	"DegF/min",				// 94
	"NO_UNITS",				// 95
	"ppm",					// 96
	"ppb",					// 97
	"%",					// 98
	"%/sec",				// 99
	"/min",					//100
	"/sec",					//101
	"PSI/DegF",				//102
	"RAD",					//103
	"RPM",					//104
    };
}
