/**
 * @preserve
 * Copyright 2016, Contemporary Control Systems, Inc.
 */

/**
 * URL currently used for all rdom request.
 */
var xmlCgiUrl = 'status_post.cgi';		//Specify correct url.

/**
 * RdomDoc for XML transfers.
 */
var mapstatus;

/**
 * Browser version.
 */
var browser;

/**
 * Form objects.
 */
var lblStatus;		// Status label.

//#############################################################################
//
//  Get correct version of browser.
//
//#############################################################################

/**
 * This function returns Internet Explorer's major version number,
 * or 0 for others. It works by finding the "MSIE " string and
 * extracting the version number following the space, up to the decimal
 * point, ignoring the minor version number
 *
 * From: http://stackoverflow.com/questions/2490452/using-javascript-to-detect-browser-type
 *
 * @constructor
 */
function BrowserVersion()
{
    var ua = window.navigator.userAgent;
    var msie = ua.indexOf ( "MSIE " );

    if ( msie > 0 )      // If Internet Explorer, return version number
        this.version = parseInt (ua.substring (msie+5, ua.indexOf (".", msie )) , 10);
    else                 // If another browser, return 0
        this.version = 0;
}

//#############################################################################
//
//  XMLHttpRequest functions.
//
//#############################################################################

/**
 * Creates a new, blank, document.
 *
 * @param targetUrl
 * @constructor
 */
function rdomDoc(targetUrl)
{
    this.targetUrl = targetUrl;
}

/**
 * Send <rdom> request to target.
 *
 * Response is element tree.
 *
 * @param req_string = <rdom> request string.
 * @returns {*}
 */
rdomDoc.prototype.Request = function (req_string)
{
    var xml_req;
    var xml_parser;
    var doc;
    var ele;
    var	state, childList, node;
    var	span, texts;
    
    // Create request object.
    if (window.XMLHttpRequest)
    {
        // For all modern browsers
        xml_req = new XMLHttpRequest();
    }
    else if (window.ActiveXObject)
    {
        // For (older) IE
        xml_req = new ActiveXObject("Microsoft.XMLHTTP");
    }
    // If successful.
    xml_req.onreadystatechange = function()
    {
    	if(xml_req.readyState === 4)
    	{
    		if (xml_req.status === 200)
    		{
        		// If not IE8.
        		if (browser.version !== 8)
        		{
            			// Create a parser.
            			xml_parser = new DOMParser();
            			// Parse the returned text.
            			doc = xml_parser.parseFromString(xml_req.responseText, "text/xml");
        		}
        		// Else IE8.
        		else
        		{
            			doc = new ActiveXObject('Microsoft.XMLDOM');
            			doc.async = false;
            			doc.loadXML(xml_req.responseText);
        		}
        		// Return with root element of XMLDocument, <rdom>.
        		childList = doc.documentElement.childNodes;
			while(lblStatus.firstChild)
			{
				lblStatus.removeChild(lblStatus.firstChild);
			}
			for(i = 0; i < childList.length; i++)
			{
				node = childList[i];
			    	state = "Address   " + node.getElementsByTagName("m")[0].textContent;
			    	state = state + "   Dev " + node.getElementsByTagName("i")[0].textContent;
				val = node.getElementsByTagName("s")[0].textContent;
			    	if(val == 0)
				{
					span = document.createElement("span");
					span.style.color = "Green";
			    		state = state + "   Online";
					texts = document.createTextNode(state);
					span.appendChild(texts);
 					var br = document.createElement("br");
					span.appendChild(br);
					lblStatus.appendChild(span);
				}
				else 
				{			    
					span = document.createElement("span");
					span.style.color = "Black";
			    		state = state + "   Offline";
					texts = document.createTextNode(state);
					span.appendChild(texts);
 					var br = document.createElement("br");
					span.appendChild(br);
 					lblStatus.appendChild(span);
				}
			}
   		}
	}
    };
    // Open as POST, target cgi, synchronous.
    xml_req.open("POST", this.targetUrl, true);
    // Set request type.
    xml_req.setRequestHeader("Content-type", "xml");
    // Send the request.
    xml_req.send(req_string);
    // Error response from server.
};

//#############################################################################
//
//  Page specific functions.
//
//#############################################################################

function timeUpdate()
{
	var 	doc;
	var	state;

	// Make xml request.
	mapstatus.Request('<status/>');
	// Start one second timer.
	
	setTimeout(function()
	{
		// Update and retrigger.
		timeUpdate();
		//
	} , 3000);
	
}

//#############################################################################
//
//  Main function; executed when EVERYTHING else has been loaded.
//
//#############################################################################

window.onload = function ()
{
	// Find out which browser we have.
	browser = new BrowserVersion();

	// Time text.
	lblStatus = document.getElementById("status");
	
	// Initialize transfer object.
	mapstatus = new rdomDoc(xmlCgiUrl);

	// Start time update.
	timeUpdate();
};
