#!/bin/sh

# source cfg file

. /app/config/vpn.cfg 2> /dev/null


file1=/etc/openvpn/client/router.ovpn
file2=/etc/openvpn/client/openvpn.up
file3=/etc/openvpn/client/cfg_ip
file4=/etc/openvpn/client/openvpn.down

#
# create /etc/openvpn/router.ovpn file
#
echo client > $file1
echo dev tun >> $file1
if [ "$OPENVPN_PROTO" = "udp" ]; then
	echo proto $OPENVPN_PROTO >> $file1
else
	echo proto tcp >> $file1
fi
echo remote $OPENVPN_REMOTE_IPADDR $OPENVPN_PORT >> $file1

if [ "$OPENVPN_PROTO" = "udp" ]; then
	echo explicit-exit-notify 1 >> $file1
fi
echo comp-lzo >> $file1
echo resolv-retry infinite >> $file1
echo keepalive $OPENVPN_PING_INTVL $OPENVPN_PING_TOUT >> $file1
echo ca /etc/openvpn/client/ca_cert.crt >> $file1
echo cert /etc/openvpn/client/local_cert.crt >> $file1
echo key /etc/openvpn/client/local.key >> $file1
echo float >> $file1
echo nobind >> $file1
echo ns-cert-type server >> $file1
echo script-security 2 >> $file1
echo route-up $file2 >> $file1
echo down $file4 >> $file1

#
# create certificate files
#
echo $OPENVPN_CA_CERT | base64 -d > /etc/openvpn/client/ca_cert.crt
echo $OPENVPN_LOCAL_CERT | base64 -d > /etc/openvpn/client/local_cert.crt
echo $OPENVPN_LOCAL_KEY | base64 -d > /etc/openvpn/client/local.key

#
# Get VPN and Local subnet addresses contained in config file
echo $OPENVPN_DESCRIPTION > $file3
echo $OPENVPN_REMOTE_IPADDR >> $file3
grep iptables /app/config/vpn.cfg | awk '{ print $7 }' | sed -n 2,3p >> $file3

#
# create /etc/openvpn/openvpn.up file
#
echo '#!/bin/sh' > $file2
cat /app/config/vpn.cfg | grep iptables | grep -e '-I'| awk -F= '{ print $2 }' >> $file2
#masq_on=$(cat /app/config/vpn.cfg | grep iptables | grep -i -e 'MASQUERADE' | wc -l)
#if [ "$masq_on" = "2" ]; then
#	echo 'iptables -t nat -I POSTROUTING -o eth0 -j MASQUERADE' >> $file2
#fi
echo 'iptables -A INPUT -i tun+ -j ACCEPT' >> $file2
echo 'iptables -A FORWARD -i tun+ -j ACCEPT' >> $file2
echo -e 'local_ip=$(cat /etc/openvpn/client/cfg_ip | sed -n 4,4p | sed "s/\47//g")' >> $file2     # note Octal 47 is the single quote character
echo 'iptables -t nat -A POSTROUTING -d $local_ip -j ACCEPT' >> $file2
chmod a+x $file2


#
# create /etc/openvpn/openvpn.down file
#
cp -a $file2 $file4
sed -i 's/-I/-D/g' $file4
sed -i 's/-A/-D/g' $file4

exit 0
